/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.ByteData;
import org.teatrove.trove.io.CharToByteBuffer;
import org.teatrove.trove.io.DefaultCharToByteBuffer;

public class FastCharToByteBuffer
implements CharToByteBuffer,
Serializable {
    private static final int TEMP_BUF_LEN = 512;
    private static final Set SUPPORTED_ENCODINGS = new HashSet();
    private ByteBuffer mBuffer;
    private transient byte[] mTempBytes;
    private transient char[] mTempChars;
    private CharToByteBuffer mSlowConvertor;

    static boolean isSupportedEncoding(String encoding) {
        return SUPPORTED_ENCODINGS.contains(encoding);
    }

    public FastCharToByteBuffer(ByteBuffer buffer) {
        this(buffer, null);
    }

    public FastCharToByteBuffer(ByteBuffer buffer, String defaultEncoding) {
        this.mBuffer = buffer;
        try {
            this.setEncoding(defaultEncoding);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setEncoding(String enc) throws IOException {
        this.drain();
        this.mSlowConvertor = FastCharToByteBuffer.isSupportedEncoding(enc) ? null : new DefaultCharToByteBuffer(this.mBuffer, enc);
    }

    @Override
    public String getEncoding() throws IOException {
        return this.mSlowConvertor != null ? this.mSlowConvertor.getEncoding() : "ISO-8859-1";
    }

    @Override
    public long getBaseByteCount() throws IOException {
        this.drain();
        return this.mBuffer.getBaseByteCount();
    }

    @Override
    public long getByteCount() throws IOException {
        this.drain();
        return this.mBuffer.getByteCount();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.drain();
        this.mBuffer.writeTo(out);
    }

    @Override
    public void append(byte b) throws IOException {
        this.drain();
        this.mBuffer.append(b);
    }

    @Override
    public void append(byte[] bytes) throws IOException {
        this.append(bytes, 0, bytes.length);
    }

    @Override
    public void append(byte[] bytes, int offset, int length) throws IOException {
        if (length != 0) {
            this.drain();
            this.mBuffer.append(bytes, offset, length);
        }
    }

    @Override
    public void appendSurrogate(ByteData s) throws IOException {
        if (s != null) {
            this.drain();
            this.mBuffer.appendSurrogate(s);
        }
    }

    @Override
    public void addCaptureBuffer(ByteBuffer buffer) throws IOException {
        this.drain();
        this.mBuffer.addCaptureBuffer(buffer);
    }

    @Override
    public void removeCaptureBuffer(ByteBuffer buffer) throws IOException {
        this.drain();
        this.mBuffer.removeCaptureBuffer(buffer);
    }

    @Override
    public void append(char c) throws IOException {
        char[] chars = this.getTempChars();
        chars[0] = c;
        this.append(chars, 0, 1);
    }

    @Override
    public void append(char[] chars) throws IOException {
        this.append(chars, 0, chars.length);
    }

    @Override
    public void append(char[] chars, int offset, int length) throws IOException {
        if (this.mSlowConvertor != null) {
            this.mSlowConvertor.append(chars, offset, length);
            return;
        }
        this.appendFast(chars, offset, length);
    }

    @Override
    public void append(String str) throws IOException {
        this.append(str, 0, str.length());
    }

    @Override
    public void append(String str, int offset, int length) throws IOException {
        if (this.mSlowConvertor != null) {
            this.mSlowConvertor.append(str, offset, length);
            return;
        }
        if (length == 0) {
            return;
        }
        char[] tempChars = this.getTempChars();
        int bufLen = tempChars.length;
        while (length >= bufLen) {
            str.getChars(offset, offset + bufLen, tempChars, 0);
            offset += bufLen;
            length -= bufLen;
            this.appendFast(tempChars, 0, bufLen);
        }
        if (length > 0) {
            str.getChars(offset, offset + length, tempChars, 0);
            this.appendFast(tempChars, 0, length);
        }
    }

    @Override
    public void reset() throws IOException {
        this.mBuffer.reset();
    }

    @Override
    public void drain() throws IOException {
        if (this.mSlowConvertor != null) {
            this.mSlowConvertor.drain();
        }
    }

    private void appendFast(char[] chars, int offset, int length) throws IOException {
        byte[] tempBytes = this.getTempBytes();
        int bufLen = tempBytes.length;
        int bi = 0;
        int climit = offset + length;
        for (int ci = offset; ci < climit; ++ci) {
            tempBytes[bi++] = (byte)chars[ci];
            if (bi < bufLen) continue;
            this.mBuffer.append(tempBytes, 0, bufLen);
            bi = 0;
        }
        if (bi > 0) {
            this.mBuffer.append(tempBytes, 0, bi);
        }
    }

    private byte[] getTempBytes() {
        if (this.mTempBytes == null) {
            this.mTempBytes = new byte[512];
        }
        return this.mTempBytes;
    }

    private char[] getTempChars() {
        if (this.mTempChars == null) {
            this.mTempChars = new char[512];
        }
        return this.mTempChars;
    }

    static {
        SUPPORTED_ENCODINGS.add("8859-1");
        SUPPORTED_ENCODINGS.add("8859_1");
        SUPPORTED_ENCODINGS.add("iso-8859-1");
        SUPPORTED_ENCODINGS.add("ISO-8859-1");
        SUPPORTED_ENCODINGS.add("iso8859_1");
        SUPPORTED_ENCODINGS.add("ISO8859_1");
    }
}

