/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FastBufferedInputStream
extends FilterInputStream {
    private byte[] mBuffer;
    private int mCount;
    private int mPos;
    private int mMarkPos = -1;
    private int mMarkLimit;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public FastBufferedInputStream(InputStream in) {
        this(in, 2048);
    }

    public FastBufferedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.mBuffer = new byte[size];
    }

    private void fill() throws IOException {
        if (this.mMarkPos < 0) {
            this.mPos = 0;
        } else if (this.mPos >= this.mBuffer.length) {
            if (this.mMarkPos > 0) {
                int sz = this.mPos - this.mMarkPos;
                System.arraycopy(this.mBuffer, this.mMarkPos, this.mBuffer, 0, sz);
                this.mPos = sz;
                this.mMarkPos = 0;
            } else if (this.mBuffer.length >= this.mMarkLimit) {
                this.mMarkPos = -1;
                this.mPos = 0;
            } else {
                int nsz = this.mPos * 2;
                if (nsz > this.mMarkLimit) {
                    nsz = this.mMarkLimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.mBuffer, 0, nbuf, 0, this.mPos);
                this.mBuffer = nbuf;
            }
        }
        this.mCount = this.mPos;
        int n = this.in.read(this.mBuffer, this.mPos, this.mBuffer.length - this.mPos);
        if (n > 0) {
            this.mCount = n + this.mPos;
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.mPos >= this.mCount) {
            this.fill();
            if (this.mPos >= this.mCount) {
                return -1;
            }
        }
        return this.mBuffer[this.mPos++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.mCount - this.mPos;
        if (avail <= 0) {
            if (len >= this.mBuffer.length && this.mMarkPos < 0) {
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.mCount - this.mPos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.mBuffer, this.mPos, b, off, cnt);
        this.mPos += cnt;
        return cnt;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n1;
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.read1(b, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && this.in.available() > 0 && (n1 = this.read1(b, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.mCount - this.mPos;
        if (avail <= 0L) {
            if (this.mMarkPos < 0) {
                return this.in.skip(n);
            }
            this.fill();
            avail = this.mCount - this.mPos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.mPos = (int)((long)this.mPos + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.mCount - this.mPos + this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.mMarkLimit = readlimit;
        this.mMarkPos = this.mPos;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.mMarkPos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.mPos = this.mMarkPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.mBuffer = null;
        }
    }
}

