/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.teatrove.trove.io.DataIO;

public abstract class AbstractDataOutputStream
extends OutputStream
implements DataOutput {
    private byte[] mTemp;

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        DataIO.writeShort(this, v, this.tempArray());
    }

    @Override
    public void writeChar(int v) throws IOException {
        DataIO.writeChar(this, v, this.tempArray());
    }

    @Override
    public void writeInt(int v) throws IOException {
        DataIO.writeInt(this, v, this.tempArray());
    }

    @Override
    public void writeLong(long v) throws IOException {
        DataIO.writeLong(this, v, this.tempArray());
    }

    @Override
    public void writeFloat(float v) throws IOException {
        DataIO.writeFloat(this, v, this.tempArray());
    }

    @Override
    public void writeDouble(double v) throws IOException {
        DataIO.writeDouble(this, v, this.tempArray());
    }

    @Override
    public void writeBytes(String s) throws IOException {
        DataIO.writeBytes(this, s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        DataIO.writeChars(this, s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int length = s.length();
        char[] chars = new char[length];
        s.getChars(0, length, chars, 0);
        int utflen = DataIO.calculateUTFLength(chars, 0, length);
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utflen);
        DataIO.writeUTF(this, chars, 0, length);
    }

    private byte[] tempArray() {
        if (this.mTemp == null) {
            this.mTemp = new byte[8];
        }
        return this.mTemp;
    }
}

