/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.teatrove.trove.io.DataIO;

public abstract class AbstractDataInputStream
extends InputStream
implements DataInput {
    private byte[] mTemp;

    @Override
    public void readFully(byte[] b) throws IOException {
        DataIO.readFully(this, b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int offset, int length) throws IOException {
        DataIO.readFully(this, b, offset, length);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return DataIO.readBoolean(this);
    }

    @Override
    public byte readByte() throws IOException {
        return DataIO.readByte(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return DataIO.readUnsignedByte(this);
    }

    @Override
    public short readShort() throws IOException {
        return DataIO.readShort(this, this.tempArray());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return DataIO.readUnsignedShort(this, this.tempArray());
    }

    @Override
    public char readChar() throws IOException {
        return DataIO.readChar(this, this.tempArray());
    }

    @Override
    public int readInt() throws IOException {
        return DataIO.readInt(this, this.tempArray());
    }

    @Override
    public long readLong() throws IOException {
        return DataIO.readLong(this, this.tempArray());
    }

    @Override
    public float readFloat() throws IOException {
        return DataIO.readFloat(this, this.tempArray());
    }

    @Override
    public double readDouble() throws IOException {
        return DataIO.readDouble(this, this.tempArray());
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("readLine not supported");
    }

    @Override
    public String readUTF() throws IOException {
        int bytesExpected = this.readUnsignedShort();
        char[] chars = new char[bytesExpected];
        int charCount = DataIO.readUTF(this, chars, 0, bytesExpected, bytesExpected);
        return new String(chars, 0, charCount);
    }

    private byte[] tempArray() {
        if (this.mTemp == null) {
            this.mTemp = new byte[8];
        }
        return this.mTemp;
    }
}

