/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.generics;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import org.teatrove.trove.generics.AbstractGenericHandler;
import org.teatrove.trove.generics.GenericType;

public class GenericArrayTypeHandler
extends AbstractGenericHandler<GenericArrayType> {
    private boolean resolved;
    private GenericType rawType;
    private int dimensions;
    private GenericType componentType;
    private GenericType rootComponentType;

    public GenericArrayTypeHandler(GenericType rootType, GenericArrayType genericType) {
        super(rootType, genericType);
    }

    @Override
    public GenericType getRawType() {
        this.resolve();
        return this.rawType;
    }

    @Override
    public int getDimensions() {
        this.resolve();
        return this.dimensions;
    }

    @Override
    public GenericType getComponentType() {
        this.resolve();
        return this.componentType;
    }

    @Override
    public GenericType getRootComponentType() {
        this.resolve();
        return this.rootComponentType;
    }

    protected void resolve() {
        if (!this.resolved) {
            this.resolve0();
            this.resolved = true;
        }
    }

    protected void resolve0() {
        this.componentType = new GenericType(((GenericArrayType)this.getGenericType()).getGenericComponentType());
        this.dimensions = 0;
        Object compType = this.getGenericType();
        while (compType instanceof GenericArrayType) {
            ++this.dimensions;
            compType = ((GenericArrayType)compType).getGenericComponentType();
        }
        GenericType rootType = this.getRootType();
        this.rootComponentType = new GenericType(rootType, (Type)compType);
        int[] dims = new int[this.dimensions];
        GenericType rawType = this.rootComponentType.getRawType();
        Class<?> clazz = Array.newInstance(rawType.getType(), dims).getClass();
        this.rawType = new GenericType(rootType, clazz, (Type)this.getGenericType());
    }
}

