/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.generics;

import org.teatrove.trove.generics.AbstractGenericHandler;
import org.teatrove.trove.generics.GenericType;

public class ClassHandler
extends AbstractGenericHandler<Class<?>> {
    private boolean resolved;
    private GenericType rawType;
    private int dimensions;
    private GenericType componentType;
    private GenericType rootComponentType;

    public ClassHandler(GenericType rootType, Class<?> genericType) {
        super(rootType, genericType);
    }

    @Override
    public GenericType getRawType() {
        this.resolve();
        return this.rawType;
    }

    @Override
    public int getDimensions() {
        this.resolve();
        return this.dimensions;
    }

    @Override
    public GenericType getComponentType() {
        this.resolve();
        return this.componentType;
    }

    @Override
    public GenericType getRootComponentType() {
        this.resolve();
        return this.rootComponentType;
    }

    protected void resolve() {
        if (!this.resolved) {
            this.resolve0();
            this.resolved = true;
        }
    }

    protected void resolve0() {
        this.componentType = new GenericType(((Class)this.getGenericType()).getComponentType());
        this.rawType = new GenericType((Class)this.getGenericType());
        this.dimensions = 0;
        Class<?> compType = (Class<?>)this.getGenericType();
        while (compType.isArray()) {
            ++this.dimensions;
            compType = compType.getComponentType();
        }
        GenericType rootType = this.getRootType();
        this.rootComponentType = new GenericType(rootType, compType);
    }
}

