/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.IOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.util.ReadWriteLock;

public class ReadOnlyFileBuffer
implements FileBuffer {
    private final FileBuffer mFile;

    private static final IOException fail() {
        return new IOException("FileBuffer is read-only");
    }

    public ReadOnlyFileBuffer(FileBuffer file) {
        this.mFile = file;
    }

    @Override
    public int read(long position, byte[] dst, int offset, int length) throws IOException {
        return this.mFile.read(position, dst, offset, length);
    }

    @Override
    public int write(long position, byte[] src, int offset, int length) throws IOException {
        throw ReadOnlyFileBuffer.fail();
    }

    @Override
    public int read(long position) throws IOException {
        return this.mFile.read(position);
    }

    @Override
    public void write(long position, int value) throws IOException {
        throw ReadOnlyFileBuffer.fail();
    }

    @Override
    public long size() throws IOException {
        return this.mFile.size();
    }

    @Override
    public void truncate(long size) throws IOException {
        throw ReadOnlyFileBuffer.fail();
    }

    @Override
    public ReadWriteLock lock() {
        return this.mFile.lock();
    }

    @Override
    public boolean force() throws IOException {
        throw ReadOnlyFileBuffer.fail();
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.mFile.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.mFile.close();
    }
}

