/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.teatrove.trove.file.Bitlist;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.file.FileBufferInputStream;
import org.teatrove.trove.file.FileBufferOutputStream;
import org.teatrove.trove.file.NonTxFileBuffer;
import org.teatrove.trove.file.TxFileBuffer;
import org.teatrove.trove.util.ReadWriteLock;
import org.teatrove.trove.util.SecureReadWriteLock;
import org.teatrove.trove.util.SoftHashMap;

public class MultiplexFile {
    private static final int MAGIC = -1046237294;
    final TxFileBuffer mBackingFile;
    final int mBlockSize;
    final int mBlockIdScale;
    final long mMaxBlockId;
    final int mLengthScale;
    final long mMaxLength;
    final int mFileTableEntrySize;
    final int mTotalBlocksPosition;
    final int mFirstFreeBlockPosition;
    final int mFileTableSelfEntryPosition;
    final int mFreeBlocksBitlistEntryPosition;
    final long[] mLevelMaxSizes;
    final long[] mLevelMaxBlocks;
    private long mTotalBlocks;
    private final FileBuffer mFileTable;
    private final SecureReadWriteLock mFileTableLock;
    private final Bitlist mFreeBlocksBitlist;
    private long mFirstFreeBlock;
    private final byte[] mClearArray;
    private final Map mOpenFiles;

    private static long getScaledValue(FileBuffer buffer, int scale, long position) throws IOException {
        return MultiplexFile.getScaledValue(new byte[8], buffer, scale, position);
    }

    private static long getScaledValue(byte[] temp, FileBuffer buffer, int scale, long position) throws IOException {
        int amt = buffer.read(position, temp, 8 - scale, scale);
        if (amt < scale) {
            int i = 8 - scale;
            if (amt > 0) {
                i += amt;
            }
            while (i < 8) {
                temp[i++] = 0;
            }
        }
        long value = 0L;
        switch (scale) {
            default: {
                value |= (long)temp[0] << 56;
            }
            case 7: {
                value |= ((long)temp[1] & 0xFFL) << 48;
            }
            case 6: {
                value |= ((long)temp[2] & 0xFFL) << 40;
            }
            case 5: {
                value |= ((long)temp[3] & 0xFFL) << 32;
            }
            case 4: {
                value |= ((long)temp[4] & 0xFFL) << 24;
            }
            case 3: {
                value |= ((long)temp[5] & 0xFFL) << 16;
            }
            case 2: {
                value |= ((long)temp[6] & 0xFFL) << 8;
            }
            case 1: {
                value |= (long)temp[7] & 0xFFL;
            }
            case 0: 
        }
        return value;
    }

    private static void putScaledValue(FileBuffer buffer, int scale, long position, long value) throws IOException {
        MultiplexFile.putScaledValue(new byte[8], buffer, scale, position, value);
    }

    private static void putScaledValue(byte[] temp, FileBuffer buffer, int scale, long position, long value) throws IOException {
        switch (scale) {
            default: {
                temp[0] = (byte)(value >> 56);
            }
            case 7: {
                temp[1] = (byte)(value >> 48);
            }
            case 6: {
                temp[2] = (byte)(value >> 40);
            }
            case 5: {
                temp[3] = (byte)(value >> 32);
            }
            case 4: {
                temp[4] = (byte)(value >> 24);
            }
            case 3: {
                temp[5] = (byte)(value >> 16);
            }
            case 2: {
                temp[6] = (byte)(value >> 8);
            }
            case 1: {
                temp[7] = (byte)value;
            }
            case 0: 
        }
        buffer.write(position, temp, 8 - scale, scale);
    }

    public MultiplexFile(FileBuffer fb, int reserved) throws IOException {
        this(fb, false, reserved, 0, 0, 0);
    }

    public MultiplexFile(FileBuffer fb, int reserved, int blockSize, int blockIdScale, int lengthScale) throws IOException {
        this(fb, true, reserved, blockSize, blockIdScale, lengthScale);
    }

    private MultiplexFile(FileBuffer fb, boolean create, int reserved, int blockSize, int blockIdScale, int lengthScale) throws IOException {
        this.mBackingFile = fb instanceof TxFileBuffer ? (TxFileBuffer)fb : new NonTxFileBuffer(fb);
        this.mTotalBlocksPosition = reserved + 4 + 4 + 1 + 1;
        if (create) {
            if (blockSize <= 0) {
                throw new IllegalArgumentException("Block size must be > 0");
            }
            if (blockIdScale < 1 || blockIdScale > 8) {
                throw new IllegalArgumentException("Valid block id scale range is 1..8");
            }
            if (blockIdScale * 2 > blockSize) {
                throw new IllegalArgumentException("Block size must be large enough to contain two block ids: " + blockIdScale * 2 + " > " + blockSize);
            }
            if (blockSize % blockIdScale != 0) {
                throw new IllegalArgumentException("Block size must be multiple of block id scale: " + blockSize + " % " + blockIdScale + " = " + blockSize % blockIdScale);
            }
            if (lengthScale < 0 || lengthScale > 8) {
                throw new IllegalArgumentException("Valid length scale range is 0..8");
            }
            this.mBlockSize = blockSize;
            this.mBlockIdScale = blockIdScale;
            this.mLengthScale = lengthScale;
        } else {
            FileBufferInputStream din = new FileBufferInputStream(fb, reserved, false);
            if (-1046237294 != din.readInt()) {
                throw new IOException("Incorrect magic number");
            }
            this.mBlockSize = din.readInt();
            this.mBlockIdScale = din.readByte();
            this.mLengthScale = din.readByte();
        }
        long max = (1L << this.mBlockIdScale * 8) - 1L;
        if (max <= 1L) {
            max = Long.MAX_VALUE;
        }
        this.mMaxBlockId = max;
        if (this.mLengthScale == 0) {
            max = this.mBlockSize;
        } else {
            BigInteger maxAllocation;
            max = 1L << this.mLengthScale * 8;
            if (max <= 1L) {
                max = Long.MAX_VALUE;
            }
            if ((maxAllocation = BigInteger.valueOf(this.mMaxBlockId).multiply(BigInteger.valueOf(this.mBlockSize))).compareTo(BigInteger.valueOf(max)) < 0) {
                max = maxAllocation.longValue();
            }
        }
        this.mMaxLength = max;
        this.mFileTableEntrySize = this.mLengthScale + this.mBlockIdScale;
        if (this.mFileTableEntrySize > this.mBlockSize) {
            throw new IllegalArgumentException("Block size must be large enough to contain one file table entry: " + this.mFileTableEntrySize + " > " + this.mBlockSize);
        }
        this.mFirstFreeBlockPosition = this.mTotalBlocksPosition + this.mBlockIdScale;
        this.mFileTableSelfEntryPosition = this.mFirstFreeBlockPosition + this.mBlockIdScale;
        this.mFreeBlocksBitlistEntryPosition = this.mFileTableSelfEntryPosition + this.mFileTableEntrySize;
        int headerSize = this.mFreeBlocksBitlistEntryPosition + this.mFileTableEntrySize;
        if (create) {
            FileBufferOutputStream dout = new FileBufferOutputStream(fb, reserved, false);
            dout.writeInt(-1046237294);
            dout.writeInt(this.mBlockSize);
            dout.writeByte((byte)this.mBlockIdScale);
            dout.writeByte((byte)this.mLengthScale);
            this.setTotalBlocks((headerSize - 1) / this.mBlockSize);
            this.setFirstFreeBlock(0L);
            this.putLengthEntry(fb, this.mFreeBlocksBitlistEntryPosition, 0L);
            this.putLengthEntry(fb, this.mFileTableSelfEntryPosition, 0L);
        } else {
            this.mTotalBlocks = this.getBlockId(fb, (long)this.mTotalBlocksPosition);
            this.mFirstFreeBlock = this.getBlockId(fb, (long)this.mFirstFreeBlockPosition);
        }
        long[] levelMaxSizes = new long[64];
        long levelSize = this.mBlockSize;
        long blockIdsPerBlock = this.mBlockSize / this.mBlockIdScale;
        int level = 0;
        while (level < 64) {
            levelMaxSizes[level++] = levelSize;
            long nextLevelSize = levelSize * blockIdsPerBlock;
            if (nextLevelSize / blockIdsPerBlock == levelSize) {
                levelSize = nextLevelSize;
                continue;
            }
            levelMaxSizes[level++] = Long.MAX_VALUE;
            break;
        }
        this.mLevelMaxSizes = new long[level];
        System.arraycopy(levelMaxSizes, 0, this.mLevelMaxSizes, 0, level);
        this.mLevelMaxBlocks = new long[64];
        long exponent = 1L;
        level = 0;
        while (level < 64) {
            this.mLevelMaxBlocks[level++] = exponent;
            if (exponent >= Long.MAX_VALUE) continue;
            long nextExponent = exponent * blockIdsPerBlock;
            if (nextExponent / blockIdsPerBlock == exponent) {
                exponent = nextExponent;
                continue;
            }
            exponent = Long.MAX_VALUE;
        }
        this.mClearArray = new byte[Math.min(this.mBlockSize, 4096)];
        InternalFile internalFileTable = new InternalFile(fb, this.mFileTableSelfEntryPosition, false);
        this.mFileTableLock = internalFileTable.mLock;
        this.mFileTable = new IndirectFile(internalFileTable);
        this.mFreeBlocksBitlist = new Bitlist(new IndirectFile(new InternalFile(fb, this.mFreeBlocksBitlistEntryPosition, true)));
        this.mOpenFiles = new SoftHashMap();
    }

    public FileBuffer openFile(long id) throws IOException {
        return new IndirectFile(this.openInternal(new Long(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(long id) throws IOException {
        if (id >= this.getFileCount()) {
            return;
        }
        Long key = new Long(id);
        InternalFile file = this.openInternal(key);
        try {
            file.lock().acquireWriteLock();
            try {
                this.mFileTableLock.acquireWriteLock();
                file.delete();
                this.mOpenFiles.remove(key);
            }
            finally {
                this.mFileTableLock.releaseLock();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            file.lock().releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalFile openInternal(Long key) throws IOException {
        if (key < 0L) {
            throw new IllegalArgumentException("File id must be positive: " + key);
        }
        try {
            this.mFileTableLock.acquireUpgradableLock();
            InternalFile file = (InternalFile)this.mOpenFiles.get(key);
            if (file == null) {
                long id = key;
                long fileTablePos = id * (long)this.mFileTableEntrySize;
                this.mFileTableLock.acquireWriteLock();
                try {
                    file = (InternalFile)this.mOpenFiles.get(key);
                    if (file != null) {
                        InternalFile internalFile = file;
                        return internalFile;
                    }
                    if (id >= this.getFileCount()) {
                        this.putLengthEntry(this.mFileTable, fileTablePos, 0L);
                    }
                    file = new InternalFile(this.mFileTable, fileTablePos, false);
                    this.mOpenFiles.put(key, file);
                }
                finally {
                    this.mFileTableLock.releaseLock();
                }
            }
            InternalFile internalFile = file;
            return internalFile;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mFileTableLock.releaseLock();
        }
    }

    public long getFileCount() throws IOException {
        return this.mFileTable.size() / (long)this.mFileTableEntrySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateFileCount(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException("count < 0: " + count);
        }
        try {
            this.mFileTableLock.acquireUpgradableLock();
            long oldCount = this.getFileCount();
            if (count >= oldCount) {
                return;
            }
            this.mFileTableLock.acquireWriteLock();
            try {
                long id = oldCount;
                while (--id >= count) {
                    this.deleteFile(id);
                }
                this.mFileTable.truncate(count * (long)this.mFileTableEntrySize);
            }
            finally {
                this.mFileTableLock.releaseLock();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mFileTableLock.releaseLock();
        }
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public int getBlockIdScale() {
        return this.mBlockIdScale;
    }

    public int getLengthScale() {
        return this.mLengthScale;
    }

    public long getMaximumFileLength() {
        return this.mMaxLength;
    }

    public void dumpStructure(long id) throws IOException {
        InternalFile file = this.openInternal(new Long(id));
        System.out.println("Size: " + file.size());
        System.out.print("Block list: ");
        file.dumpBlocks();
    }

    final int calcLevels(long length) {
        int index = Arrays.binarySearch(this.mLevelMaxSizes, length);
        return index < 0 ? ~index : index;
    }

    final long calcBlockCount(long length) {
        return (length + (long)this.mBlockSize - 1L) / (long)this.mBlockSize;
    }

    final long allocBlock(boolean markInUse) throws IOException {
        try {
            this.mFreeBlocksBitlist.lock().acquireWriteLock();
            long blockId = this.mFirstFreeBlock;
            if (blockId <= 0L) {
                blockId = this.mTotalBlocks + 1L;
                if (blockId > this.mMaxBlockId) {
                    throw new IOException("Cannot allocate any more file blocks");
                }
                this.setTotalBlocks(blockId);
            } else {
                long nextFree = this.mFreeBlocksBitlist.findFirstSet(blockId + 1L);
                if (nextFree <= 0L) {
                    this.setFirstFreeBlock(0L);
                } else {
                    this.setFirstFreeBlock(nextFree);
                }
            }
            if (markInUse) {
                this.mFreeBlocksBitlist.clear(blockId);
            }
            long l = blockId;
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mFreeBlocksBitlist.lock().releaseLock();
        }
    }

    final void clearBlock(long blockId) throws IOException {
        this.clearSubBlock(blockId, 0, this.mBlockSize);
    }

    final void clearSubBlock(long blockId, int start, int length) throws IOException {
        if (length <= this.mClearArray.length) {
            this.mBackingFile.write(blockId * (long)this.mBlockSize + (long)start, this.mClearArray, 0, length);
        } else {
            int amt;
            long pos = blockId * (long)this.mBlockSize + (long)start;
            do {
                amt = Math.min(length, this.mClearArray.length);
                amt = this.mBackingFile.write(pos, this.mClearArray, 0, amt);
                pos += (long)amt;
            } while ((length -= amt) > 0);
        }
    }

    final void freeBlock(long blockId) throws IOException {
        if (blockId != 0L) {
            try {
                this.mFreeBlocksBitlist.lock().acquireWriteLock();
                this.mFreeBlocksBitlist.set(blockId);
                if (this.mFirstFreeBlock == 0L || blockId < this.mFirstFreeBlock) {
                    this.setFirstFreeBlock(blockId);
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mFreeBlocksBitlist.lock().releaseLock();
            }
        }
    }

    final long getLengthEntry(FileBuffer buffer, long position) throws IOException {
        if (this.mLengthScale == 0) {
            if (this.getBlockId(buffer, position) == 0L) {
                return 0L;
            }
            return this.mBlockSize;
        }
        try {
            buffer.lock().acquireReadLock();
            long length = MultiplexFile.getScaledValue(buffer, this.mLengthScale, position);
            if (length == 0L && this.getBlockId(buffer, position + (long)this.mLengthScale) == 0L) {
                long l = 0L;
                return l;
            }
            long l = length + 1L;
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            buffer.lock().releaseLock();
        }
    }

    final long putLengthEntry(FileBuffer buffer, long position, long length) throws IOException {
        if (this.mLengthScale == 0) {
            if (length != 0L) {
                return this.mBlockSize;
            }
            this.putBlockId(buffer, position, 0L);
        } else {
            try {
                buffer.lock().acquireWriteLock();
                if (length == 0L) {
                    MultiplexFile.putScaledValue(buffer, this.mLengthScale, position, 0L);
                    this.putBlockId(buffer, position + (long)this.mLengthScale, 0L);
                } else {
                    MultiplexFile.putScaledValue(buffer, this.mLengthScale, position, length - 1L);
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                buffer.lock().releaseLock();
            }
        }
        return length;
    }

    final long getBlockId(FileBuffer buffer, long position) throws IOException {
        return MultiplexFile.getScaledValue(buffer, this.mBlockIdScale, position);
    }

    final long getBlockId(byte[] tempArray, FileBuffer buffer, long position) throws IOException {
        return MultiplexFile.getScaledValue(tempArray, buffer, this.mBlockIdScale, position);
    }

    final long getBlockId(long refBlockId, int index) throws IOException {
        if (refBlockId == 0L) {
            return 0L;
        }
        return this.getBlockId(this.mBackingFile, refBlockId * (long)this.mBlockSize + (long)index);
    }

    final long getBlockId(byte[] tempArray, long refBlockId, int index) throws IOException {
        if (refBlockId == 0L) {
            return 0L;
        }
        return this.getBlockId(tempArray, this.mBackingFile, refBlockId * (long)this.mBlockSize + (long)index);
    }

    final void putBlockId(FileBuffer buffer, long position, long blockId) throws IOException {
        MultiplexFile.putScaledValue(buffer, this.mBlockIdScale, position, blockId);
    }

    final void putBlockId(byte[] tempArray, FileBuffer buffer, long position, long blockId) throws IOException {
        MultiplexFile.putScaledValue(tempArray, buffer, this.mBlockIdScale, position, blockId);
    }

    final void putBlockId(long refBlockId, int index, long blockId) throws IOException {
        this.putBlockId(this.mBackingFile, refBlockId * (long)this.mBlockSize + (long)index, blockId);
    }

    final void putBlockId(byte[] tempArray, long refBlockId, int index, long blockId) throws IOException {
        this.putBlockId(tempArray, this.mBackingFile, refBlockId * (long)this.mBlockSize + (long)index, blockId);
    }

    private void setTotalBlocks(long totalBlocks) throws IOException {
        this.mTotalBlocks = totalBlocks;
        this.putBlockId(this.mBackingFile, (long)this.mTotalBlocksPosition, totalBlocks);
    }

    private void setFirstFreeBlock(long blockId) throws IOException {
        this.mFirstFreeBlock = blockId;
        this.putBlockId(this.mBackingFile, (long)this.mFirstFreeBlockPosition, blockId);
    }

    private class MapNode {
        public final long mBlockId;
        private final byte[] mTemp = new byte[8];
        private Reference[] mChildren;

        public MapNode(long blockId) {
            this.mBlockId = blockId;
        }

        public synchronized MapNode getChild(int index) throws IOException {
            MapNode child;
            Reference ref;
            if (this.mChildren == null) {
                this.mChildren = new Reference[MultiplexFile.this.mBlockSize / MultiplexFile.this.mBlockIdScale];
            }
            if ((ref = this.mChildren[index]) == null || (child = (MapNode)ref.get()) == null) {
                long childId = MultiplexFile.this.getBlockId(this.mTemp, this.mBlockId, index * MultiplexFile.this.mBlockIdScale);
                if (childId == 0L) {
                    return null;
                }
                child = new MapNode(childId);
                this.mChildren[index] = new SoftReference<MapNode>(child);
            }
            return child;
        }

        public synchronized MapNode setChild(int index, long childId) throws IOException {
            if (this.mChildren == null) {
                this.mChildren = new Reference[MultiplexFile.this.mBlockSize / MultiplexFile.this.mBlockIdScale];
            }
            MultiplexFile.this.putBlockId(this.mTemp, this.mBlockId, index * MultiplexFile.this.mBlockIdScale, childId);
            if (childId == 0L) {
                this.mChildren[index] = null;
                return null;
            }
            MapNode child = new MapNode(childId);
            this.mChildren[index] = new SoftReference<MapNode>(child);
            return child;
        }

        public MapNode setChild(int index, MapNode child) throws IOException {
            return this.setChild(index, child == null ? 0L : child.mBlockId);
        }

        public String toString() {
            return super.toString() + ':' + this.mBlockId;
        }
    }

    private final class InternalFile
    implements FileBuffer {
        final SecureReadWriteLock mLock = new SecureReadWriteLock();
        private FileBuffer mFileTableBuffer;
        private final long mFileTablePosition;
        private final boolean mIsFreeFile;
        private MapNode mRootNode;
        private long mLength = -1L;
        private int mLevels;
        private byte[] mWriteOneByte;

        InternalFile(FileBuffer fileTableBuffer, long fileTablePosition, boolean isFreeFile) throws IOException {
            this.mFileTableBuffer = fileTableBuffer;
            this.mFileTablePosition = fileTablePosition;
            this.mIsFreeFile = isFreeFile;
            long blockId = this.getFileTableEntryBlockId();
            if (blockId != 0L) {
                this.mRootNode = new MapNode(blockId);
            }
        }

        @Override
        public int read(long position, byte[] dst, int offset, int length) throws IOException {
            this.checkDeleted();
            if (position >= this.size()) {
                return -1;
            }
            if (length == 0) {
                return 0;
            }
            if (position + (long)length > this.size()) {
                length = (int)(this.size() - position);
            }
            return this.read(position, dst, offset, length, this.mLevels, this.mRootNode);
        }

        private int read(long position, byte[] dst, int offset, int length, int level, MapNode node) throws IOException {
            int amt;
            if (level == 0) {
                int indexInBlock = (int)(position % (long)MultiplexFile.this.mBlockSize);
                int amt2 = MultiplexFile.this.mBlockSize - indexInBlock;
                if (amt2 > length) {
                    amt2 = length;
                }
                if (node == null) {
                    int i = amt2;
                    while (--i >= 0) {
                        dst[offset + i] = 0;
                    }
                } else {
                    MultiplexFile.this.mBackingFile.read(node.mBlockId * (long)MultiplexFile.this.mBlockSize + (long)indexInBlock, dst, offset, amt2);
                }
                return amt2;
            }
            int index = (int)(position / MultiplexFile.this.mLevelMaxBlocks[level] % (long)MultiplexFile.this.mBlockSize) / MultiplexFile.this.mBlockIdScale;
            int originalOffset = offset;
            --level;
            int blockIdsPerBlock = MultiplexFile.this.mBlockSize / MultiplexFile.this.mBlockIdScale;
            while (index < blockIdsPerBlock && (amt = this.read(position, dst, offset, length, level, node == null ? null : node.getChild(index))) > 0) {
                offset += amt;
                if ((length -= amt) <= 0) break;
                position += (long)amt;
                ++index;
            }
            return offset - originalOffset;
        }

        @Override
        public int write(long position, byte[] src, int offset, int length) throws IOException {
            this.checkDeleted();
            if (length == 0) {
                return 0;
            }
            if (position >= MultiplexFile.this.mMaxLength) {
                throw new EOFException("position > max file length: " + position + " > " + MultiplexFile.this.mMaxLength);
            }
            long newLength = position + (long)length;
            long oldLength = this.size();
            if (newLength > MultiplexFile.this.mMaxLength) {
                newLength = MultiplexFile.this.mMaxLength;
                length = (int)(newLength - position);
            }
            MultiplexFile.this.mBackingFile.begin();
            if (newLength > oldLength) {
                int newLevels = MultiplexFile.this.calcLevels(newLength);
                if (newLevels > this.mLevels && this.mRootNode != null) {
                    for (int i = this.mLevels; i < newLevels; ++i) {
                        long blockId = MultiplexFile.this.allocBlock(!this.mIsFreeFile);
                        MultiplexFile.this.clearBlock(blockId);
                        MapNode newRoot = new MapNode(blockId);
                        newRoot.setChild(0, this.mRootNode);
                        this.mRootNode = newRoot;
                    }
                    this.putFileTableEntryBlockId(this.mRootNode.mBlockId);
                }
                this.mLength = MultiplexFile.this.putLengthEntry(this.mFileTableBuffer, this.mFileTablePosition, newLength);
                this.mLevels = newLevels;
            }
            if (this.mRootNode == null) {
                long blockId = MultiplexFile.this.allocBlock(!this.mIsFreeFile);
                if (this.mLevels > 0 || this.mIsFreeFile) {
                    MultiplexFile.this.clearBlock(blockId);
                }
                this.mRootNode = new MapNode(blockId);
                this.putFileTableEntryBlockId(this.mRootNode.mBlockId);
            }
            if (position > oldLength) {
                this.clearNewRegion(oldLength, position - oldLength);
            }
            int amt = this.write(position, src, offset, length, this.mLevels, this.mRootNode);
            MultiplexFile.this.mBackingFile.commit();
            return amt;
        }

        private int write(long position, byte[] src, int offset, int length, int level, MapNode node) throws IOException {
            if (level == 0) {
                int indexInBlock = (int)(position % (long)MultiplexFile.this.mBlockSize);
                int amt = MultiplexFile.this.mBlockSize - indexInBlock;
                if (amt >= length) {
                    amt = length;
                }
                MultiplexFile.this.mBackingFile.write(node.mBlockId * (long)MultiplexFile.this.mBlockSize + (long)indexInBlock, src, offset, amt);
                return amt;
            }
            int index = (int)(position / MultiplexFile.this.mLevelMaxBlocks[level] % (long)MultiplexFile.this.mBlockSize) / MultiplexFile.this.mBlockIdScale;
            int originalOffset = offset;
            --level;
            int blockIdsPerBlock = MultiplexFile.this.mBlockSize / MultiplexFile.this.mBlockIdScale;
            while (index < blockIdsPerBlock) {
                int amt;
                MapNode nextNode = node.getChild(index);
                if (nextNode == null) {
                    long newBlockId = MultiplexFile.this.allocBlock(!this.mIsFreeFile);
                    if (level > 0 || this.mIsFreeFile) {
                        MultiplexFile.this.clearBlock(newBlockId);
                    }
                    nextNode = node.setChild(index, newBlockId);
                }
                if ((amt = this.write(position, src, offset, length, level, nextNode)) <= 0) break;
                offset += amt;
                if ((length -= amt) <= 0) break;
                position += (long)amt;
                ++index;
            }
            return offset - originalOffset;
        }

        private void clearNewRegion(long position, long length) throws IOException {
            long seam = (position + (long)MultiplexFile.this.mBlockSize - 1L) / (long)MultiplexFile.this.mBlockSize * (long)MultiplexFile.this.mBlockSize;
            long len = seam - position;
            if (len > 0L) {
                if (len > length) {
                    len = length;
                }
                this.writeClear(position, len);
                if (len >= length) {
                    return;
                }
            }
            if ((len = position + length - (seam = (position + length) / (long)MultiplexFile.this.mBlockSize * (long)MultiplexFile.this.mBlockSize)) > 0L) {
                this.writeClear(seam, len);
            }
        }

        private void writeClear(long position, long length) throws IOException {
            int amt;
            if (length <= (long)MultiplexFile.this.mClearArray.length) {
                this.write(position, MultiplexFile.this.mClearArray, 0, (int)length, this.mLevels, this.mRootNode);
                return;
            }
            do {
                amt = (int)Math.min(length, (long)MultiplexFile.this.mClearArray.length);
                amt = this.write(position, MultiplexFile.this.mClearArray, 0, amt, this.mLevels, this.mRootNode);
                position += (long)amt;
            } while ((length -= (long)amt) > 0L);
        }

        @Override
        public int read(long position) throws IOException {
            this.checkDeleted();
            if (position >= this.size()) {
                return -1;
            }
            return this.read(position, this.mLevels, this.mRootNode);
        }

        private int read(long position, int level, MapNode node) throws IOException {
            if (node == null) {
                return 0;
            }
            if (level == 0) {
                int indexInBlock = (int)(position % (long)MultiplexFile.this.mBlockSize);
                int value = MultiplexFile.this.mBackingFile.read(node.mBlockId * (long)MultiplexFile.this.mBlockSize + (long)indexInBlock);
                return value < 0 ? 0 : value;
            }
            int index = (int)(position / MultiplexFile.this.mLevelMaxBlocks[level] % (long)MultiplexFile.this.mBlockSize) / MultiplexFile.this.mBlockIdScale;
            return this.read(position, level - 1, node.getChild(index));
        }

        @Override
        public void write(long position, int value) throws IOException {
            byte[] writeOne = this.mWriteOneByte;
            if (this.mWriteOneByte == null) {
                writeOne = this.mWriteOneByte = new byte[1];
            }
            writeOne[0] = (byte)value;
            this.write(position, writeOne, 0, 1);
        }

        @Override
        public long size() throws IOException {
            this.checkDeleted();
            if (this.mLength < 0L) {
                this.mLength = MultiplexFile.this.getLengthEntry(this.mFileTableBuffer, this.mFileTablePosition);
                this.mLevels = MultiplexFile.this.calcLevels(this.mLength);
            }
            return this.mLength;
        }

        @Override
        public void truncate(long size) throws IOException {
            int newLevels;
            this.checkDeleted();
            if (size >= this.size()) {
                return;
            }
            long blockCount = MultiplexFile.this.calcBlockCount(this.mLength);
            long newBlockCount = MultiplexFile.this.calcBlockCount(size);
            long blocksToFree = blockCount - newBlockCount;
            MapNode rootNode = this.mRootNode;
            long rootBlockId = rootNode == null ? 0L : rootNode.mBlockId;
            MultiplexFile.this.mBackingFile.begin();
            this.mLength = MultiplexFile.this.putLengthEntry(this.mFileTableBuffer, this.mFileTablePosition, size);
            if (blocksToFree == 0L) {
                MultiplexFile.this.mBackingFile.commit();
                return;
            }
            ArrayList<MapNode> chain = null;
            if (size == 0L) {
                this.putFileTableEntryBlockId(0L);
                this.mRootNode = null;
                if (this.mLevels == 0) {
                    MultiplexFile.this.freeBlock(rootBlockId);
                    MultiplexFile.this.mBackingFile.commit();
                    return;
                }
                newLevels = this.mLevels;
            } else {
                newLevels = MultiplexFile.this.calcLevels(size);
                if (newLevels < this.mLevels) {
                    chain = new ArrayList<MapNode>(64);
                    MapNode newRoot = rootNode;
                    for (int i = this.mLevels; newRoot != null && i > newLevels; newRoot = newRoot.getChild(0), --i) {
                        chain.add(newRoot);
                    }
                    this.putFileTableEntryBlockId(newRoot == null ? 0L : newRoot.mBlockId);
                    this.mRootNode = newRoot;
                }
            }
            long amt = this.truncateBlocks(blockCount - 1L, blocksToFree, this.mLevels, rootNode);
            if (amt > 0L) {
                MultiplexFile.this.freeBlock(rootBlockId);
            } else if (chain != null) {
                int i = chain.size();
                while (--i >= 0) {
                    MultiplexFile.this.freeBlock(((MapNode)chain.get((int)i)).mBlockId);
                }
            }
            this.mLevels = newLevels;
            MultiplexFile.this.mBackingFile.commit();
        }

        private long truncateBlocks(long endBlockId, long blocksToFree, int level, MapNode node) throws IOException {
            boolean totallyFreed;
            int index;
            if (level == 0) {
                return 1L;
            }
            int blockIdsPerBlock = MultiplexFile.this.mBlockSize / MultiplexFile.this.mBlockIdScale;
            if (node == null) {
                long amt = endBlockId % (long)blockIdsPerBlock + 1L;
                if (amt > blocksToFree) {
                    return blocksToFree ^ 0xFFFFFFFFFFFFFFFFL;
                }
                return amt;
            }
            if (level <= 1) {
                index = (int)(endBlockId % (long)blockIdsPerBlock);
                totallyFreed = blocksToFree > (long)index;
            } else {
                index = (int)(endBlockId / MultiplexFile.this.mLevelMaxBlocks[level - 1] % (long)blockIdsPerBlock);
                totallyFreed = blocksToFree > endBlockId % MultiplexFile.this.mLevelMaxBlocks[level];
            }
            long original = blocksToFree;
            --level;
            while (index >= 0 && blocksToFree > 0L) {
                MapNode childNode = node.getChild(index);
                long amt = this.truncateBlocks(endBlockId, blocksToFree, level, childNode);
                if (amt < 0L) {
                    amt ^= 0xFFFFFFFFFFFFFFFFL;
                } else if (childNode != null) {
                    MultiplexFile.this.freeBlock(childNode.mBlockId);
                    if (!totallyFreed) {
                        node.setChild(index, 0L);
                    }
                }
                endBlockId -= amt;
                blocksToFree -= amt;
                --index;
            }
            if (totallyFreed) {
                return original - blocksToFree;
            }
            return original - blocksToFree ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public ReadWriteLock lock() {
            return this.mLock;
        }

        @Override
        public boolean force() throws IOException {
            this.checkDeleted();
            return MultiplexFile.this.mBackingFile.force();
        }

        @Override
        public boolean isReadOnly() throws IOException {
            this.checkDeleted();
            return false;
        }

        @Override
        public boolean isOpen() {
            return this.mFileTableBuffer != null;
        }

        @Override
        public void close() throws IOException {
        }

        void delete() throws IOException {
            try {
                this.mLock.acquireWriteLock();
                this.truncate(0L);
                this.mFileTableBuffer = null;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        void dumpBlocks() throws IOException {
            try {
                this.mLock.acquireReadLock();
                this.dumpBlocks(0L, this.size(), this.mLevels, this.mRootNode);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
            System.out.println();
        }

        private long dumpBlocks(long position, long length, int level, MapNode node) throws IOException {
            if (length == 0L) {
                return 0L;
            }
            if (level == 0) {
                if (node == null) {
                    System.out.print("null ");
                } else {
                    System.out.print(node.mBlockId);
                    System.out.print(' ');
                }
                return length - (long)MultiplexFile.this.mBlockSize;
            }
            int index = (int)(position / MultiplexFile.this.mLevelMaxBlocks[level] % (long)MultiplexFile.this.mBlockSize) / MultiplexFile.this.mBlockIdScale;
            --level;
            int blockIdsPerBlock = MultiplexFile.this.mBlockSize / MultiplexFile.this.mBlockIdScale;
            while (index < blockIdsPerBlock) {
                long newLength = this.dumpBlocks(position, length, level, node == null ? null : node.getChild(index));
                long amt = length - newLength;
                length = newLength;
                if (length <= 0L) break;
                position += amt;
                ++index;
            }
            return length;
        }

        private long getFileTableEntryBlockId() throws IOException {
            return MultiplexFile.this.getBlockId(this.mFileTableBuffer, this.mFileTablePosition + (long)MultiplexFile.this.mLengthScale);
        }

        private void putFileTableEntryBlockId(long blockId) throws IOException {
            MultiplexFile.this.putBlockId(this.mFileTableBuffer, this.mFileTablePosition + (long)MultiplexFile.this.mLengthScale, blockId);
        }

        private void checkDeleted() throws IOException {
            if (this.mFileTableBuffer == null) {
                throw new FileNotFoundException("FileBuffer deleted");
            }
        }
    }

    private static final class IndirectFile
    implements FileBuffer,
    ReadWriteLock {
        private final InternalFile mFile;
        private final SecureReadWriteLock mLock;
        private boolean mClosed;

        IndirectFile(InternalFile file) {
            this.mFile = file;
            this.mLock = file.mLock;
        }

        @Override
        public int read(long position, byte[] dst, int offset, int length) throws IOException {
            this.checkArgs(position, dst, offset, length);
            this.checkClosed();
            try {
                this.mLock.acquireReadLock();
                int n = this.mFile.read(position, dst, offset, length);
                return n;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public int write(long position, byte[] src, int offset, int length) throws IOException {
            this.checkArgs(position, src, offset, length);
            this.checkClosed();
            try {
                this.mLock.acquireWriteLock();
                int n = this.mFile.write(position, src, offset, length);
                return n;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public int read(long position) throws IOException {
            if (position < 0L) {
                throw new IllegalArgumentException("position < 0: " + position);
            }
            this.checkClosed();
            try {
                this.mLock.acquireReadLock();
                int n = this.mFile.read(position);
                return n;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public void write(long position, int value) throws IOException {
            if (position < 0L) {
                throw new IllegalArgumentException("position < 0: " + position);
            }
            this.checkClosed();
            try {
                this.mLock.acquireWriteLock();
                this.mFile.write(position, value);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public long size() throws IOException {
            try {
                this.mLock.acquireReadLock();
                long l = this.mFile.size();
                return l;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public void truncate(long size) throws IOException {
            if (size < 0L) {
                throw new IllegalArgumentException("size < 0: " + size);
            }
            this.checkClosed();
            try {
                this.mLock.acquireWriteLock();
                this.mFile.truncate(size);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public ReadWriteLock lock() {
            return this;
        }

        @Override
        public void acquireReadLock() throws InterruptedException {
            this.checkClosedLock();
            this.mLock.acquireReadLock();
        }

        @Override
        public boolean acquireReadLock(long timeout) throws InterruptedException {
            this.checkClosedLock();
            return this.mLock.acquireReadLock(timeout);
        }

        @Override
        public void acquireUpgradableLock() throws InterruptedException {
            this.checkClosedLock();
            this.mLock.acquireUpgradableLock();
        }

        @Override
        public boolean acquireUpgradableLock(long timeout) throws InterruptedException {
            this.checkClosedLock();
            return this.mLock.acquireUpgradableLock(timeout);
        }

        @Override
        public void acquireWriteLock() throws InterruptedException {
            this.checkClosedLock();
            this.mLock.acquireWriteLock();
        }

        @Override
        public boolean acquireWriteLock(long timeout) throws InterruptedException {
            this.checkClosedLock();
            return this.mLock.acquireWriteLock(timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean releaseLock() {
            if (this.mClosed) {
                boolean result = false;
                try {
                    while (this.mLock.releaseLock()) {
                        result |= true;
                    }
                }
                finally {
                    return result;
                }
            }
            return this.mLock.releaseLock();
        }

        @Override
        public long getDefaultTimeout() {
            return this.mLock.getDefaultTimeout();
        }

        @Override
        public boolean force() throws IOException {
            this.checkClosed();
            try {
                this.mLock.acquireReadLock();
                boolean bl = this.mFile.force();
                return bl;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isOpen() {
            return !this.mClosed;
        }

        @Override
        public void close() throws IOException {
            this.mClosed = true;
            while (this.mLock.releaseLock()) {
            }
        }

        private void checkArgs(long position, byte[] array, int offset, int length) {
            if (position < 0L) {
                throw new IllegalArgumentException("position < 0: " + position);
            }
            if (offset < 0) {
                throw new ArrayIndexOutOfBoundsException("offset < 0: " + offset);
            }
            if (length < 0) {
                throw new IndexOutOfBoundsException("length < 0: " + length);
            }
            if (offset + length > array.length) {
                throw new ArrayIndexOutOfBoundsException("offset + length > array length: " + (offset + length) + " > " + array.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkClosed() throws IOException {
            if (this.mClosed) {
                try {
                    while (this.mLock.releaseLock()) {
                    }
                }
                finally {
                    throw new IOException("FileBuffer closed");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkClosedLock() throws IllegalStateException {
            if (this.mClosed) {
                try {
                    while (this.mLock.releaseLock()) {
                    }
                }
                finally {
                    throw new IllegalStateException("FileBuffer closed");
                }
            }
        }
    }
}

