/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.util.ReadWriteLock;
import org.teatrove.trove.util.SecureReadWriteLock;

class MappedFileBuffer
implements FileBuffer {
    private long mAddr;
    private int mSize;
    private final boolean mReadOnly;
    private final SecureReadWriteLock mLock;

    public MappedFileBuffer(long handle, int mode, long position, int size, SecureReadWriteLock lock) throws IOException {
        this.mAddr = MappedFileBuffer.open(handle, mode, position, size);
        this.mSize = size;
        this.mReadOnly = mode == 1;
        this.mLock = lock;
    }

    @Override
    public int read(long position, byte[] dst, int offset, int length) throws IOException {
        this.checkArgs(position, dst, offset, length);
        if (length == 0) {
            return 0;
        }
        try {
            this.mLock.acquireReadLock();
            this.checkClosed();
            if (position >= (long)this.mSize) {
                int n = -1;
                return n;
            }
            if (position + (long)length > (long)this.mSize) {
                length = (int)((long)this.mSize - position);
            }
            int n = this.read(dst, offset, length, this.mAddr + position);
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public int write(long position, byte[] src, int offset, int length) throws IOException {
        this.checkArgs(position, src, offset, length);
        if (length == 0) {
            return 0;
        }
        try {
            this.mLock.acquireWriteLock();
            this.checkClosed();
            if (position >= (long)this.mSize) {
                throw new EOFException("position > max file length: " + position + " > " + this.mSize);
            }
            if (position + (long)length > (long)this.mSize) {
                length = (int)((long)this.mSize - position);
            }
            int n = this.write(src, offset, length, this.mAddr + position);
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public int read(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        try {
            this.mLock.acquireReadLock();
            this.checkClosed();
            if (position >= (long)this.mSize) {
                int n = -1;
                return n;
            }
            int n = this.read(this.mAddr + position);
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public void write(long position, int value) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        try {
            this.mLock.acquireWriteLock();
            this.checkClosed();
            if (position >= (long)this.mSize) {
                throw new EOFException("position > max file length: " + position + " > " + this.mSize);
            }
            this.write(this.mAddr + position, value);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public long size() throws IOException {
        try {
            this.mLock.acquireReadLock();
            this.checkClosed();
            long l = this.mSize;
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public void truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("size < 0: " + size);
        }
        try {
            this.mLock.acquireWriteLock();
            this.checkClosed();
            if (size < (long)this.mSize) {
                this.mSize = (int)size;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public ReadWriteLock lock() {
        return this.mLock;
    }

    @Override
    public boolean force() throws IOException {
        try {
            this.mLock.acquireWriteLock();
            this.checkClosed();
            this.force(this.mAddr, this.mSize);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
        return true;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        this.checkClosed();
        return this.mReadOnly;
    }

    @Override
    public boolean isOpen() {
        return this.mAddr != 0L;
    }

    @Override
    public void close() throws IOException {
        try {
            this.mLock.acquireWriteLock();
            if (this.mAddr != 0L) {
                this.mAddr = 0L;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    private void checkClosed() throws IOException {
        if (this.mAddr == 0L) {
            throw new IOException("FileBuffer closed");
        }
    }

    private void checkArgs(long position, byte[] array, int offset, int length) {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("offset < 0: " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length < 0: " + length);
        }
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException("offset + length > array length: " + (offset + length) + " > " + array.length);
        }
    }

    private static native long open(long var0, int var2, long var3, int var5) throws IOException;

    private native int read(byte[] var1, int var2, int var3, long var4) throws IOException;

    private native int write(byte[] var1, int var2, int var3, long var4) throws IOException;

    private native int read0(long var1) throws IOException;

    private native void write0(long var1, int var3) throws IOException;

    private native void force(long var1, int var3) throws IOException;
}

