/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile.generics;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.teatrove.trove.classfile.generics.AbstractGenericTypeDesc;
import org.teatrove.trove.classfile.generics.ClassTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeFactory;
import org.teatrove.trove.classfile.generics.InternFactory;

public class WildcardTypeDesc
extends AbstractGenericTypeDesc<WildcardType> {
    private final GenericTypeDesc lowerBounds;
    private final GenericTypeDesc upperBounds;

    public static WildcardTypeDesc forType(GenericTypeDesc lowerBounds, GenericTypeDesc upperBounds) {
        return InternFactory.intern(new WildcardTypeDesc(lowerBounds, upperBounds));
    }

    public static WildcardTypeDesc forType(WildcardType type) {
        return InternFactory.intern(new WildcardTypeDesc(type));
    }

    protected WildcardTypeDesc(GenericTypeDesc lowerBounds, GenericTypeDesc upperBounds) {
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
    }

    protected WildcardTypeDesc(WildcardType type) {
        Type[] lbounds = type.getLowerBounds();
        this.lowerBounds = lbounds != null && lbounds.length > 0 ? GenericTypeFactory.fromType(lbounds[0]) : null;
        Type[] ubounds = type.getUpperBounds();
        this.upperBounds = ubounds != null && ubounds.length > 0 ? GenericTypeFactory.fromType(ubounds[0]) : null;
    }

    public GenericTypeDesc getLowerBounds() {
        return this.lowerBounds;
    }

    public GenericTypeDesc getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public String getSignature() {
        String name;
        ClassTypeDesc clazz;
        StringBuilder buffer = new StringBuilder(256);
        boolean found = false;
        if (this.lowerBounds != null) {
            found = true;
            if (this.lowerBounds instanceof ClassTypeDesc) {
                clazz = (ClassTypeDesc)this.lowerBounds;
                name = clazz.getClassName();
                if (Object.class.getName().equals(name)) {
                    found = false;
                }
            }
            if (found) {
                buffer.append('-').append(this.lowerBounds.getSignature());
            }
        }
        if (this.upperBounds != null) {
            found = true;
            if (this.upperBounds instanceof ClassTypeDesc) {
                clazz = (ClassTypeDesc)this.upperBounds;
                name = clazz.getClassName();
                if (Object.class.getName().equals(name)) {
                    found = false;
                }
            }
            if (found) {
                buffer.append('+').append(this.upperBounds.getSignature());
            }
        }
        if (!found) {
            buffer.append('*');
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WildcardTypeDesc)) {
            return false;
        }
        WildcardTypeDesc type = (WildcardTypeDesc)other;
        return (this.lowerBounds == null && type.lowerBounds == null || this.lowerBounds != null && this.lowerBounds.equals(type.lowerBounds)) && (this.upperBounds == null && type.upperBounds == null || this.upperBounds != null && this.upperBounds.equals(type.upperBounds));
    }

    @Override
    public int hashCode() {
        return (this.lowerBounds == null ? 0 : this.lowerBounds.hashCode() * 11) + (this.upperBounds == null ? 0 : this.upperBounds.hashCode() * 17);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("?");
        if (this.lowerBounds != null) {
            buffer.append(" super ").append(this.lowerBounds.toString());
        }
        if (this.upperBounds != null) {
            buffer.append(" extends ").append(this.upperBounds.toString());
        }
        return buffer.toString();
    }
}

