/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Map;
import org.teatrove.trove.classfile.Descriptor;
import org.teatrove.trove.classfile.generics.GenericArrayTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeFactory;
import org.teatrove.trove.util.FlyweightSet;
import org.teatrove.trove.util.IdentityMap;

public abstract class TypeDesc
extends Descriptor
implements Serializable {
    public static final int OBJECT_CODE = 0;
    public static final int VOID_CODE = 1;
    public static final int BOOLEAN_CODE = 4;
    public static final int CHAR_CODE = 5;
    public static final int FLOAT_CODE = 6;
    public static final int DOUBLE_CODE = 7;
    public static final int BYTE_CODE = 8;
    public static final int SHORT_CODE = 9;
    public static final int INT_CODE = 10;
    public static final int LONG_CODE = 11;
    public static final TypeDesc VOID;
    public static final TypeDesc BOOLEAN;
    public static final TypeDesc CHAR;
    public static final TypeDesc BYTE;
    public static final TypeDesc SHORT;
    public static final TypeDesc INT;
    public static final TypeDesc LONG;
    public static final TypeDesc FLOAT;
    public static final TypeDesc DOUBLE;
    public static final TypeDesc OBJECT;
    public static final TypeDesc STRING;
    static final FlyweightSet cInstances;
    static final Map cClassesToInstances;
    final transient String mDescriptor;

    static TypeDesc intern(TypeDesc type) {
        return (TypeDesc)cInstances.put(type);
    }

    public static synchronized TypeDesc forClass(Class clazz, Type genericType) {
        if (clazz == null) {
            return null;
        }
        if (genericType == null || genericType == clazz) {
            return TypeDesc.forClass(clazz);
        }
        return TypeDesc.forClass(clazz, GenericTypeFactory.fromType(genericType));
    }

    public static synchronized TypeDesc forClass(Class clazz, GenericTypeDesc genericType) {
        if (clazz == null) {
            return null;
        }
        if (genericType == null) {
            return TypeDesc.forClass(clazz);
        }
        ClassKey key = new ClassKey(clazz, genericType);
        TypeDesc type = (TypeDesc)cClassesToInstances.get(key);
        if (type != null) {
            return type;
        }
        if (clazz.isArray()) {
            type = genericType instanceof GenericArrayTypeDesc ? TypeDesc.forClass(clazz.getComponentType(), ((GenericArrayTypeDesc)genericType).getComponentType()).toArrayType() : TypeDesc.forClass(clazz.getComponentType()).toArrayType();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                type = INT;
            }
            if (clazz == Boolean.TYPE) {
                type = BOOLEAN;
            }
            if (clazz == Character.TYPE) {
                type = CHAR;
            }
            if (clazz == Byte.TYPE) {
                type = BYTE;
            }
            if (clazz == Long.TYPE) {
                type = LONG;
            }
            if (clazz == Float.TYPE) {
                type = FLOAT;
            }
            if (clazz == Double.TYPE) {
                type = DOUBLE;
            }
            if (clazz == Short.TYPE) {
                type = SHORT;
            }
            if (clazz == Void.TYPE) {
                type = VOID;
            }
        } else {
            String name = clazz.getName();
            type = TypeDesc.intern(new GenericType(TypeDesc.generateDescriptor(name), name, genericType));
        }
        cClassesToInstances.put(key, type);
        return type;
    }

    public static synchronized TypeDesc forClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        TypeDesc type = (TypeDesc)cClassesToInstances.get(clazz);
        if (type != null) {
            return type;
        }
        if (clazz.isArray()) {
            type = TypeDesc.forClass(clazz.getComponentType()).toArrayType();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                type = INT;
            }
            if (clazz == Boolean.TYPE) {
                type = BOOLEAN;
            }
            if (clazz == Character.TYPE) {
                type = CHAR;
            }
            if (clazz == Byte.TYPE) {
                type = BYTE;
            }
            if (clazz == Long.TYPE) {
                type = LONG;
            }
            if (clazz == Float.TYPE) {
                type = FLOAT;
            }
            if (clazz == Double.TYPE) {
                type = DOUBLE;
            }
            if (clazz == Short.TYPE) {
                type = SHORT;
            }
            if (clazz == Void.TYPE) {
                type = VOID;
            }
        } else {
            String name = clazz.getName();
            type = TypeDesc.intern(new ObjectType(TypeDesc.generateDescriptor(name), name));
        }
        cClassesToInstances.put(clazz, type);
        return type;
    }

    public static TypeDesc forClass(String name) throws IllegalArgumentException {
        if (name.length() < 1) {
            throw TypeDesc.invalidName(name);
        }
        int index1 = name.lastIndexOf(91);
        int index2 = name.lastIndexOf(93);
        if (index2 >= 0) {
            if (index2 + 1 != name.length() || index1 + 1 != index2) {
                throw TypeDesc.invalidName(name);
            }
            try {
                return TypeDesc.forClass(name.substring(0, index1)).toArrayType();
            }
            catch (IllegalArgumentException e) {
                throw TypeDesc.invalidName(name);
            }
        }
        if (index1 >= 0) {
            throw TypeDesc.invalidName(name);
        }
        switch (name.charAt(0)) {
            case 'v': {
                if (!name.equals("void")) break;
                return VOID;
            }
            case 'b': {
                if (name.equals("boolean")) {
                    return BOOLEAN;
                }
                if (!name.equals("byte")) break;
                return BYTE;
            }
            case 'c': {
                if (!name.equals("char")) break;
                return CHAR;
            }
            case 's': {
                if (!name.equals("short")) break;
                return SHORT;
            }
            case 'i': {
                if (!name.equals("int")) break;
                return INT;
            }
            case 'l': {
                if (!name.equals("long")) break;
                return LONG;
            }
            case 'f': {
                if (!name.equals("float")) break;
                return FLOAT;
            }
            case 'd': {
                if (!name.equals("double")) break;
                return DOUBLE;
            }
        }
        String desc = TypeDesc.generateDescriptor(name);
        if (name.indexOf(47) >= 0) {
            name = name.replace('/', '.');
        }
        return TypeDesc.intern(new ObjectType(desc, name));
    }

    public static TypeDesc[] forClasses(Class<?>[] clazzes) {
        TypeDesc[] types = new TypeDesc[clazzes.length];
        for (int i = 0; i < clazzes.length; ++i) {
            types[i] = TypeDesc.forClass(clazzes[i]);
        }
        return types;
    }

    private static IllegalArgumentException invalidName(String name) {
        return new IllegalArgumentException("Invalid name: " + name);
    }

    public static TypeDesc forDescriptor(String desc) throws IllegalArgumentException {
        TypeDesc td;
        int cursor = 0;
        int dim = 0;
        try {
            char c;
            while ((c = desc.charAt(cursor++)) == '[') {
                ++dim;
            }
            switch (c) {
                case 'V': {
                    td = VOID;
                    break;
                }
                case 'Z': {
                    td = BOOLEAN;
                    break;
                }
                case 'C': {
                    td = CHAR;
                    break;
                }
                case 'B': {
                    td = BYTE;
                    break;
                }
                case 'S': {
                    td = SHORT;
                    break;
                }
                case 'I': {
                    td = INT;
                    break;
                }
                case 'J': {
                    td = LONG;
                    break;
                }
                case 'F': {
                    td = FLOAT;
                    break;
                }
                case 'D': {
                    td = DOUBLE;
                    break;
                }
                case 'L': {
                    if (dim > 0) {
                        desc = desc.substring(dim);
                        cursor = 1;
                    }
                    StringBuffer name = new StringBuffer(desc.length() - 2);
                    while ((c = desc.charAt(cursor++)) != ';') {
                        if (c == '/') {
                            c = '.';
                        }
                        name.append(c);
                    }
                    td = TypeDesc.intern(new ObjectType(desc, name.toString()));
                    break;
                }
                default: {
                    throw TypeDesc.invalidDescriptor(desc);
                }
            }
        }
        catch (NullPointerException e) {
            throw TypeDesc.invalidDescriptor(desc);
        }
        catch (IndexOutOfBoundsException e) {
            throw TypeDesc.invalidDescriptor(desc);
        }
        if (cursor != desc.length()) {
            throw TypeDesc.invalidDescriptor(desc);
        }
        while (--dim >= 0) {
            td = td.toArrayType();
        }
        return td;
    }

    private static IllegalArgumentException invalidDescriptor(String desc) {
        return new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    private static String generateDescriptor(String classname) {
        int length = classname.length();
        char[] buf = new char[length + 2];
        buf[0] = 76;
        classname.getChars(0, length, buf, 1);
        for (int i = 1; i <= length; ++i) {
            char c = buf[i];
            if (c != '.') continue;
            buf[i] = 47;
        }
        buf[i] = 59;
        return new String(buf);
    }

    TypeDesc(String desc) {
        this.mDescriptor = desc;
    }

    public abstract String getRootName();

    public abstract String getFullName();

    public abstract int getTypeCode();

    public abstract boolean isPrimitive();

    public abstract boolean isDoubleWord();

    public abstract boolean isArray();

    public abstract int getDimensions();

    public abstract TypeDesc getComponentType();

    public abstract TypeDesc getRootComponentType();

    public abstract TypeDesc toArrayType();

    public abstract TypeDesc toObjectType();

    public abstract TypeDesc toPrimitiveType();

    public abstract Class toClass();

    public abstract Class toClass(ClassLoader var1);

    @Override
    public String toString() {
        return this.mDescriptor;
    }

    public String getSignature() {
        return this.toString();
    }

    public int hashCode() {
        return this.mDescriptor.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TypeDesc) {
            return ((TypeDesc)other).mDescriptor.equals(this.mDescriptor);
        }
        return false;
    }

    Object writeReplace() throws ObjectStreamException {
        return new External(this.mDescriptor);
    }

    static {
        cInstances = new FlyweightSet();
        cClassesToInstances = new IdentityMap();
        VOID = TypeDesc.intern(new PrimitiveType("V", 1));
        BOOLEAN = TypeDesc.intern(new PrimitiveType("Z", 4));
        CHAR = TypeDesc.intern(new PrimitiveType("C", 5));
        BYTE = TypeDesc.intern(new PrimitiveType("B", 8));
        SHORT = TypeDesc.intern(new PrimitiveType("S", 9));
        INT = TypeDesc.intern(new PrimitiveType("I", 10));
        LONG = TypeDesc.intern(new PrimitiveType("J", 11));
        FLOAT = TypeDesc.intern(new PrimitiveType("F", 6));
        DOUBLE = TypeDesc.intern(new PrimitiveType("D", 7));
        OBJECT = TypeDesc.forClass("java.lang.Object");
        STRING = TypeDesc.forClass("java.lang.String");
    }

    private static class External
    implements Externalizable {
        private String mDescriptor;

        public External() {
        }

        public External(String desc) {
            this.mDescriptor = desc;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.mDescriptor);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.mDescriptor = in.readUTF();
        }

        public Object readResolve() throws ObjectStreamException {
            return TypeDesc.forDescriptor(this.mDescriptor);
        }
    }

    private static class ArrayType
    extends ObjectType {
        private final transient TypeDesc mComponent;
        private final transient String mFullName;

        ArrayType(String desc, TypeDesc component) {
            super(desc, component.getRootName());
            this.mComponent = component;
            this.mFullName = component.getFullName().concat("[]");
        }

        @Override
        public String getFullName() {
            return this.mFullName;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public int getDimensions() {
            return this.mComponent.getDimensions() + 1;
        }

        @Override
        public TypeDesc getComponentType() {
            return this.mComponent;
        }

        @Override
        public TypeDesc getRootComponentType() {
            TypeDesc type = this.mComponent;
            while (type.isArray()) {
                type = type.getComponentType();
            }
            return type;
        }

        @Override
        public TypeDesc toPrimitiveType() {
            return null;
        }

        @Override
        public Class toClass(ClassLoader loader) {
            if (loader == null) {
                return this.arrayClass(this.getRootComponentType().toClass());
            }
            return this.arrayClass(this.getRootComponentType().toClass(loader));
        }

        private Class arrayClass(Class clazz) {
            if (clazz == null) {
                return null;
            }
            int dim = this.getDimensions();
            try {
                if (dim == 1) {
                    return Array.newInstance(clazz, 0).getClass();
                }
                return Array.newInstance(clazz, new int[dim]).getClass();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    private static class GenericArray
    extends ArrayType {
        private transient TypeDesc mArrayType;
        private transient GenericTypeDesc mGenericDesc;

        GenericArray(String desc, TypeDesc component, GenericTypeDesc genericDesc) {
            super(desc, component);
            this.mGenericDesc = genericDesc;
        }

        public GenericTypeDesc getGenericDesc() {
            return this.mGenericDesc;
        }

        @Override
        public TypeDesc toArrayType() {
            if (this.mArrayType == null) {
                int length = this.mDescriptor.length();
                char[] buf = new char[length + 1];
                buf[0] = 91;
                this.mDescriptor.getChars(0, length, buf, 1);
                this.mArrayType = GenericArray.intern(new GenericArray(new String(buf), this, GenericArrayTypeDesc.forType(this.mGenericDesc)));
            }
            return this.mArrayType;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.mGenericDesc.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof GenericType) {
                return super.equals(other) && ((GenericType)other).mGenericDesc.equals(this.mGenericDesc);
            }
            return false;
        }

        @Override
        public String getSignature() {
            return this.mGenericDesc.getSignature();
        }
    }

    private static class ObjectType
    extends TypeDesc {
        private final transient String mName;
        private transient TypeDesc mArrayType;
        private transient TypeDesc mPrimitiveType;
        private transient Class mClass;

        ObjectType(String desc, String name) {
            super(desc);
            this.mName = name;
        }

        @Override
        public String getRootName() {
            return this.mName;
        }

        @Override
        public String getFullName() {
            return this.mName;
        }

        @Override
        public int getTypeCode() {
            return 0;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isDoubleWord() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public int getDimensions() {
            return 0;
        }

        @Override
        public TypeDesc getComponentType() {
            return null;
        }

        @Override
        public TypeDesc getRootComponentType() {
            return null;
        }

        @Override
        public TypeDesc toArrayType() {
            if (this.mArrayType == null) {
                int length = this.mDescriptor.length();
                char[] buf = new char[length + 1];
                buf[0] = 91;
                this.mDescriptor.getChars(0, length, buf, 1);
                this.mArrayType = ObjectType.intern(new ArrayType(new String(buf), this));
            }
            return this.mArrayType;
        }

        @Override
        public TypeDesc toObjectType() {
            return this;
        }

        @Override
        public TypeDesc toPrimitiveType() {
            String name;
            if (this.mPrimitiveType == null && (name = this.mName).startsWith("java.lang.") && name.length() > 10) {
                switch (name.charAt(10)) {
                    case 'V': {
                        if (!name.equals("java.lang.Void")) break;
                        this.mPrimitiveType = VOID;
                        break;
                    }
                    case 'B': {
                        if (name.equals("java.lang.Boolean")) {
                            this.mPrimitiveType = BOOLEAN;
                            break;
                        }
                        if (!name.equals("java.lang.Byte")) break;
                        this.mPrimitiveType = BYTE;
                        break;
                    }
                    case 'C': {
                        if (!name.equals("java.lang.Character")) break;
                        this.mPrimitiveType = CHAR;
                        break;
                    }
                    case 'S': {
                        if (!name.equals("java.lang.Short")) break;
                        this.mPrimitiveType = SHORT;
                        break;
                    }
                    case 'I': {
                        if (!name.equals("java.lang.Integer")) break;
                        this.mPrimitiveType = INT;
                        break;
                    }
                    case 'L': {
                        if (!name.equals("java.lang.Long")) break;
                        this.mPrimitiveType = LONG;
                        break;
                    }
                    case 'F': {
                        if (!name.equals("java.lang.Float")) break;
                        this.mPrimitiveType = FLOAT;
                        break;
                    }
                    case 'D': {
                        if (!name.equals("java.lang.Double")) break;
                        this.mPrimitiveType = DOUBLE;
                    }
                }
            }
            return this.mPrimitiveType;
        }

        @Override
        public final Class toClass() {
            if (this.mClass == null) {
                this.mClass = this.toClass(null);
            }
            return this.mClass;
        }

        @Override
        public Class toClass(ClassLoader loader) {
            TypeDesc type = this.toPrimitiveType();
            if (type != null) {
                switch (type.getTypeCode()) {
                    default: {
                        return Void.class;
                    }
                    case 4: {
                        return Boolean.class;
                    }
                    case 5: {
                        return Character.class;
                    }
                    case 6: {
                        return Float.class;
                    }
                    case 7: {
                        return Double.class;
                    }
                    case 8: {
                        return Byte.class;
                    }
                    case 9: {
                        return Short.class;
                    }
                    case 10: {
                        return Integer.class;
                    }
                    case 11: 
                }
                return Long.class;
            }
            try {
                if (loader == null) {
                    return Class.forName(this.mName);
                }
                return loader.loadClass(this.mName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private static class GenericType
    extends ObjectType {
        private transient GenericTypeDesc mGenericDesc;
        private transient TypeDesc mArrayType;

        GenericType(String desc, String name, GenericTypeDesc genericDesc) {
            super(desc, name);
            this.mGenericDesc = genericDesc;
        }

        public GenericTypeDesc getGenericDesc() {
            return this.mGenericDesc;
        }

        @Override
        public TypeDesc toArrayType() {
            if (this.mArrayType == null) {
                int length = this.mDescriptor.length();
                char[] buf = new char[length + 1];
                buf[0] = 91;
                this.mDescriptor.getChars(0, length, buf, 1);
                this.mArrayType = GenericType.intern(new GenericArray(new String(buf), this, GenericArrayTypeDesc.forType(this.mGenericDesc)));
            }
            return this.mArrayType;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.mGenericDesc.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof GenericType) {
                return super.equals(other) && ((GenericType)other).mGenericDesc.equals(this.mGenericDesc);
            }
            return false;
        }

        @Override
        public String getSignature() {
            return this.mGenericDesc.getSignature();
        }
    }

    private static class PrimitiveType
    extends TypeDesc {
        private final transient int mCode;
        private transient TypeDesc mArrayType;
        private transient TypeDesc mObjectType;

        PrimitiveType(String desc, int code) {
            super(desc);
            this.mCode = code;
        }

        @Override
        public String getRootName() {
            switch (this.mCode) {
                default: {
                    return "void";
                }
                case 4: {
                    return "boolean";
                }
                case 5: {
                    return "char";
                }
                case 8: {
                    return "byte";
                }
                case 9: {
                    return "short";
                }
                case 10: {
                    return "int";
                }
                case 11: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: 
            }
            return "double";
        }

        @Override
        public String getFullName() {
            return this.getRootName();
        }

        @Override
        public int getTypeCode() {
            return this.mCode;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public boolean isDoubleWord() {
            return this.mCode == 7 || this.mCode == 11;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public int getDimensions() {
            return 0;
        }

        @Override
        public TypeDesc getComponentType() {
            return null;
        }

        @Override
        public TypeDesc getRootComponentType() {
            return null;
        }

        @Override
        public TypeDesc toArrayType() {
            if (this.mArrayType == null) {
                char[] buf = new char[]{'[', this.mDescriptor.charAt(0)};
                this.mArrayType = PrimitiveType.intern(new ArrayType(new String(buf), this));
            }
            return this.mArrayType;
        }

        @Override
        public TypeDesc toObjectType() {
            if (this.mObjectType == null) {
                switch (this.mCode) {
                    default: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Void");
                        break;
                    }
                    case 4: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Boolean");
                        break;
                    }
                    case 5: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Character");
                        break;
                    }
                    case 8: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Byte");
                        break;
                    }
                    case 9: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Short");
                        break;
                    }
                    case 10: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Integer");
                        break;
                    }
                    case 11: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Long");
                        break;
                    }
                    case 6: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Float");
                        break;
                    }
                    case 7: {
                        this.mObjectType = PrimitiveType.forClass("java.lang.Double");
                    }
                }
            }
            return this.mObjectType;
        }

        @Override
        public TypeDesc toPrimitiveType() {
            return this;
        }

        @Override
        public Class toClass() {
            switch (this.mCode) {
                default: {
                    return Void.TYPE;
                }
                case 4: {
                    return Boolean.TYPE;
                }
                case 5: {
                    return Character.TYPE;
                }
                case 8: {
                    return Byte.TYPE;
                }
                case 9: {
                    return Short.TYPE;
                }
                case 10: {
                    return Integer.TYPE;
                }
                case 11: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: 
            }
            return Double.TYPE;
        }

        @Override
        public Class toClass(ClassLoader loader) {
            return this.toClass();
        }
    }

    protected static class ClassKey {
        private Class clazz;
        private GenericTypeDesc genericType;

        public ClassKey(Class clazz, GenericTypeDesc genericType) {
            this.clazz = clazz;
            this.genericType = genericType;
        }

        public int hashCode() {
            int hashCode = 11;
            hashCode += 13 * this.clazz.hashCode();
            if (this.genericType != null) {
                hashCode += 17 * this.genericType.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ClassKey)) {
                return false;
            }
            ClassKey other = (ClassKey)object;
            return !(!this.clazz.equals(other.clazz) || this.genericType == null && other.genericType != null || other.genericType == null && this.genericType != null) && (this.genericType == null || this.genericType.equals(other.genericType));
        }
    }
}

