/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.ClassFileDataLoader;
import org.teatrove.trove.classfile.CodeAssemblerPrinter;
import org.teatrove.trove.classfile.CodeDisassembler;
import org.teatrove.trove.classfile.FieldInfo;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.ResourceClassFileDataLoader;
import org.teatrove.trove.classfile.TypeDesc;

public class TestClassFileRead {
    public static void main(String[] args) throws Exception {
        InputStream in = new FileInputStream(args[0]);
        in = new BufferedInputStream(in);
        ResourceClassFileDataLoader loader = new ResourceClassFileDataLoader();
        ClassFile cf = ClassFile.readFrom(in, (ClassFileDataLoader)loader, null);
        in.close();
        while (cf.getOuterClass() != null) {
            cf = cf.getOuterClass();
        }
        TestClassFileRead.dump(cf);
    }

    private static void dump(ClassFile cf) {
        TestClassFileRead.dump(cf, "");
    }

    private static void dump(ClassFile cf, String indent) {
        int i;
        TestClassFileRead.println(cf, indent);
        TestClassFileRead.println("className: " + cf.getClassName(), indent);
        TestClassFileRead.println("superClassName: " + cf.getSuperClassName(), indent);
        TestClassFileRead.println("innerClass: " + cf.isInnerClass(), indent);
        TestClassFileRead.println("innerClassName: " + cf.getInnerClassName(), indent);
        TestClassFileRead.println("type: " + cf.getType(), indent);
        TestClassFileRead.println("modifiers: " + cf.getModifiers(), indent);
        String[] interfaces = cf.getInterfaces();
        TestClassFileRead.print("interfaces: ", indent);
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            if (i2 > 0) {
                System.out.print(", ");
            }
            System.out.print(interfaces[i2]);
        }
        TestClassFileRead.println();
        FieldInfo[] fields = cf.getFields();
        TestClassFileRead.println("fields: ", indent);
        for (int i3 = 0; i3 < fields.length; ++i3) {
            TestClassFileRead.dump(fields[i3], indent + "    ");
        }
        MethodInfo[] methods = cf.getMethods();
        TestClassFileRead.println("methods: ", indent);
        for (i = 0; i < methods.length; ++i) {
            TestClassFileRead.dump(methods[i], indent + "    ");
        }
        methods = cf.getConstructors();
        TestClassFileRead.println("constructors: ", indent);
        for (i = 0; i < methods.length; ++i) {
            TestClassFileRead.dump(methods[i], indent + "    ");
        }
        MethodInfo init = cf.getInitializer();
        TestClassFileRead.println("initializer: ", indent);
        if (init != null) {
            TestClassFileRead.dump(init, indent + "    ");
        }
        ClassFile[] innerClasses = cf.getInnerClasses();
        TestClassFileRead.println("innerClasses: ", indent);
        for (int i4 = 0; i4 < innerClasses.length; ++i4) {
            TestClassFileRead.dump(innerClasses[i4], indent + "    ");
        }
        TestClassFileRead.println("sourceFile: " + cf.getSourceFile(), indent);
        TestClassFileRead.println("synthetic: " + cf.isSynthetic(), indent);
        TestClassFileRead.println("deprecated: " + cf.isDeprecated(), indent);
        TestClassFileRead.println("attributes: ", indent);
        TestClassFileRead.dump(cf.getAttributes(), indent + "    ");
        TestClassFileRead.println();
    }

    private static void dump(FieldInfo field, String indent) {
        TestClassFileRead.println(field, indent);
        TestClassFileRead.println("name: " + field.getName(), indent);
        TestClassFileRead.println("type: " + field.getType(), indent);
        TestClassFileRead.println("modifiers: " + field.getModifiers(), indent);
        TestClassFileRead.println("constantValue: " + field.getConstantValue(), indent);
        TestClassFileRead.println("synthetic: " + field.isSynthetic(), indent);
        TestClassFileRead.println("deprecated: " + field.isDeprecated(), indent);
        TestClassFileRead.println("attributes: ", indent);
        TestClassFileRead.dump(field.getAttributes(), indent + "    ");
        TestClassFileRead.println();
    }

    private static void dump(MethodInfo method, String indent) {
        TestClassFileRead.println(method, indent);
        TestClassFileRead.println("name: " + method.getName(), indent);
        TestClassFileRead.println("methodDescriptor: " + method.getMethodDescriptor(), indent);
        TestClassFileRead.println("modifiers: " + method.getModifiers(), indent);
        String[] exceptions = method.getExceptions();
        TestClassFileRead.print("exceptions: ", indent);
        for (int i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                System.out.print(", ");
            }
            System.out.print(exceptions[i]);
        }
        TestClassFileRead.println();
        if (method.getCodeAttr() != null) {
            TestClassFileRead.println("code:", indent);
            PrintWriter writer = new PrintWriter(System.out);
            TypeDesc[] paramTypes = method.getMethodDescriptor().getParameterTypes();
            boolean isStatic = method.getModifiers().isStatic();
            new CodeDisassembler(method).disassemble(new CodeAssemblerPrinter(paramTypes, isStatic, writer, indent + "    ", null));
            writer.flush();
        }
        TestClassFileRead.println("synthetic: " + method.isSynthetic(), indent);
        TestClassFileRead.println("deprecated: " + method.isDeprecated(), indent);
        TestClassFileRead.println("attributes: ", indent);
        TestClassFileRead.dump(method.getAttributes(), indent + "    ");
        TestClassFileRead.println();
    }

    private static void dump(Attribute[] attributes, String indent) {
        if (attributes == null) {
            return;
        }
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            TestClassFileRead.println(attribute, indent);
            Attribute[] subAttributes = attribute.getAttributes();
            if (subAttributes == null || subAttributes.length <= 0) continue;
            TestClassFileRead.println("attributes: ", indent);
            TestClassFileRead.dump(subAttributes, indent + "    ");
        }
    }

    private static void print(Object obj, String indent) {
        System.out.print(indent);
        System.out.print(obj);
    }

    private static void println(Object obj, String indent) {
        TestClassFileRead.print(obj, indent);
        TestClassFileRead.println();
    }

    private static void println() {
        System.out.println();
    }
}

