/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;

class SignatureAttr
extends Attribute {
    private String mSignaturStr;
    private ConstantUTFInfo mSignature;

    public SignatureAttr(ConstantPool cp, String signatur) {
        super(cp, "Signature");
        this.mSignaturStr = signatur;
        this.mSignature = ConstantUTFInfo.make(cp, signatur);
    }

    public String getSignature() {
        return this.mSignaturStr;
    }

    public ConstantUTFInfo getSignatureConstant() {
        return this.mSignature;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mSignature.getIndex());
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        int index = din.readUnsignedShort();
        if ((length -= 2) > 0) {
            din.skipBytes(length);
        }
        String signature = ((ConstantUTFInfo)cp.getConstant(index)).getValue();
        return new SignatureAttr(cp, signature);
    }
}

