/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.AttributeFactory;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.CodeAttr;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.DeprecatedAttr;
import org.teatrove.trove.classfile.ExceptionsAttr;
import org.teatrove.trove.classfile.MethodDesc;
import org.teatrove.trove.classfile.Modifiers;
import org.teatrove.trove.classfile.SignatureAttr;
import org.teatrove.trove.classfile.SignatureDesc;
import org.teatrove.trove.classfile.SyntheticAttr;

public class MethodInfo {
    private ClassFile mParent;
    private ConstantPool mCp;
    private String mName;
    private MethodDesc mDesc;
    private SignatureDesc mSignature;
    private int mModifier;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;
    private ConstantUTFInfo mSignatureConstant;
    private List mAttributes = new ArrayList(2);
    private CodeAttr mCode;
    private ExceptionsAttr mExceptions;

    MethodInfo(ClassFile parent, Modifiers modifiers, String name, MethodDesc desc, SignatureDesc signature) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = name;
        this.mDesc = desc;
        this.mSignature = signature;
        this.mModifier = modifiers.getModifier();
        this.mNameConstant = ConstantUTFInfo.make(this.mCp, name);
        this.mDescriptorConstant = ConstantUTFInfo.make(this.mCp, desc.toString());
        if (!modifiers.isAbstract() && !modifiers.isNative()) {
            this.addAttribute(new CodeAttr(this.mCp));
        }
        if (this.mSignature != null) {
            String signatureStr = signature.toString();
            this.addAttribute(new SignatureAttr(this.mCp, signatureStr));
        }
    }

    private MethodInfo(ClassFile parent, int modifiers, ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = nameConstant.getValue();
        this.mDesc = MethodDesc.forDescriptor(descConstant.getValue());
        this.mModifier = modifiers;
        this.mNameConstant = nameConstant;
        this.mDescriptorConstant = descConstant;
    }

    public ClassFile getClassFile() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public MethodDesc getMethodDescriptor() {
        return this.mDesc;
    }

    public Modifiers getModifiers() {
        return new Modifiers(this.mModifier);
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public ConstantUTFInfo getDescriptorConstant() {
        return this.mDescriptorConstant;
    }

    public String[] getExceptions() {
        if (this.mExceptions == null) {
            return new String[0];
        }
        return this.mExceptions.getExceptions();
    }

    public CodeAttr getCodeAttr() {
        return this.mCode;
    }

    public boolean isSynthetic() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Object obj = this.mAttributes.get(i);
            if (!(obj instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Object obj = this.mAttributes.get(i);
            if (!(obj instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public void addException(String className) {
        if (this.mExceptions == null) {
            this.addAttribute(new ExceptionsAttr(this.mCp));
        }
        ConstantClassInfo cci = ConstantClassInfo.make(this.mCp, className);
        this.mExceptions.addException(cci);
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof CodeAttr) {
            if (this.mCode != null) {
                this.mAttributes.remove(this.mCode);
            }
            this.mCode = (CodeAttr)attr;
        } else if (attr instanceof ExceptionsAttr) {
            if (this.mExceptions != null) {
                this.mAttributes.remove(this.mExceptions);
            }
            this.mExceptions = (ExceptionsAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.mAttributes.size()];
        return this.mAttributes.toArray(attrs);
    }

    public int getLength() {
        int length = 8;
        int size = this.mAttributes.size();
        for (int i = 0; i < size; ++i) {
            length += ((Attribute)this.mAttributes.get(i)).getLength();
        }
        return length;
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mModifier);
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeShort(this.mDescriptorConstant.getIndex());
        int size = this.mAttributes.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            Attribute attr = (Attribute)this.mAttributes.get(i);
            attr.writeTo(dout);
        }
    }

    public String toString() {
        String modStr = Modifier.toString(this.mModifier);
        if (modStr.length() == 0) {
            return this.mDesc.toMethodSignature(this.getName());
        }
        return modStr + ' ' + this.mDesc.toMethodSignature(this.getName());
    }

    static MethodInfo readFrom(ClassFile parent, DataInput din, AttributeFactory attrFactory) throws IOException {
        ConstantPool cp = parent.getConstantPool();
        int modifier = din.readUnsignedShort();
        int index = din.readUnsignedShort();
        ConstantUTFInfo nameConstant = (ConstantUTFInfo)cp.getConstant(index);
        index = din.readUnsignedShort();
        ConstantUTFInfo descConstant = (ConstantUTFInfo)cp.getConstant(index);
        MethodInfo info = new MethodInfo(parent, modifier, nameConstant, descConstant);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            info.addAttribute(Attribute.readFrom(cp, din, attrFactory));
        }
        return info;
    }
}

