/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import org.teatrove.trove.classfile.Descriptor;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.util.FlyweightSet;

public class MethodDesc
extends Descriptor
implements Serializable {
    private static final TypeDesc[] EMPTY_PARAMS = new TypeDesc[0];
    private static final String[] EMPTY_PARAM_NAMES = new String[0];
    private static final FlyweightSet mInstances = TypeDesc.cInstances;
    private final transient String mDescriptor;
    private final transient TypeDesc mRetType;
    private final transient TypeDesc[] mParams;
    private final transient String[] mParamNames;

    static MethodDesc intern(MethodDesc desc) {
        return (MethodDesc)mInstances.put(desc);
    }

    public static MethodDesc forArguments(TypeDesc ret, TypeDesc ... params) {
        String[] paramNames = MethodDesc.createGenericParameterNames(params);
        return MethodDesc.forArguments(ret, params, paramNames);
    }

    static String[] createGenericParameterNames(TypeDesc ... params) {
        String[] paramNames = null;
        if (params != null) {
            paramNames = new String[params.length];
            for (int i = 0; i < paramNames.length; ++i) {
                paramNames[i] = "param$" + i;
            }
        }
        return paramNames;
    }

    public static MethodDesc forArguments(TypeDesc ret, TypeDesc[] params, String[] paramNames) {
        if (ret == null) {
            ret = TypeDesc.VOID;
        }
        if (params == null || params.length == 0) {
            params = EMPTY_PARAMS;
        }
        if (paramNames == null || paramNames.length == 0) {
            paramNames = EMPTY_PARAM_NAMES;
        }
        return MethodDesc.intern(new MethodDesc(ret, params, paramNames));
    }

    public static MethodDesc forDescriptor(String desc) throws IllegalArgumentException {
        try {
            int cursor = 0;
            char c = desc.charAt(cursor++);
            if (c != '(') {
                throw MethodDesc.invalidDescriptor(desc);
            }
            StringBuffer buf = new StringBuffer();
            ArrayList<TypeDesc> list = new ArrayList<TypeDesc>();
            block8: while ((c = desc.charAt(cursor++)) != ')') {
                block1 : switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        buf.append(c);
                        break;
                    }
                    case '[': {
                        buf.append(c);
                        continue block8;
                    }
                    case 'L': {
                        while (true) {
                            buf.append(c);
                            if (c == ';') break block1;
                            c = desc.charAt(cursor++);
                        }
                    }
                    default: {
                        throw MethodDesc.invalidDescriptor(desc);
                    }
                }
                list.add(TypeDesc.forDescriptor(buf.toString()));
                buf.setLength(0);
            }
            TypeDesc ret = TypeDesc.forDescriptor(desc.substring(cursor));
            TypeDesc[] tds = new TypeDesc[list.size()];
            tds = list.toArray(tds);
            return MethodDesc.intern(new MethodDesc(desc, ret, tds, new String[list.size()]));
        }
        catch (NullPointerException e) {
            throw MethodDesc.invalidDescriptor(desc);
        }
        catch (IndexOutOfBoundsException e) {
            throw MethodDesc.invalidDescriptor(desc);
        }
    }

    private static IllegalArgumentException invalidDescriptor(String desc) {
        return new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    private MethodDesc(TypeDesc ret, TypeDesc[] params, String[] paramNames) {
        this(MethodDesc.generateDescriptor(ret, params), ret, params, paramNames);
    }

    private MethodDesc(String desc, TypeDesc ret, TypeDesc[] params, String[] paramNames) {
        this.mDescriptor = desc;
        this.mRetType = ret;
        this.mParams = params;
        this.mParamNames = paramNames;
    }

    public TypeDesc getReturnType() {
        return this.mRetType;
    }

    public int getParameterCount() {
        return this.mParams.length;
    }

    public TypeDesc[] getParameterTypes() {
        TypeDesc[] params = this.mParams;
        return params != EMPTY_PARAMS ? (TypeDesc[])params.clone() : params;
    }

    public String[] getParameterNames() {
        String[] paramNames = this.mParamNames;
        return paramNames != EMPTY_PARAM_NAMES ? (String[])paramNames.clone() : paramNames;
    }

    public String toMethodSignature(String name) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mRetType.getFullName());
        buf.append(' ');
        buf.append(name);
        buf.append('(');
        TypeDesc[] params = this.mParams;
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(params[i].getFullName());
        }
        return buf.append(')').toString();
    }

    @Override
    public String toString() {
        return this.mDescriptor;
    }

    public int hashCode() {
        return this.mDescriptor.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MethodDesc) {
            return ((MethodDesc)other).mDescriptor.equals(this.mDescriptor);
        }
        return false;
    }

    Object writeReplace() throws ObjectStreamException {
        return new External(this.mDescriptor);
    }

    private static String generateDescriptor(TypeDesc ret, TypeDesc[] params) {
        String paramDesc;
        int paramsLength;
        int length = ret.toString().length() + 2;
        int i = paramsLength = params.length;
        while (--i >= 0) {
            length += params[i].toString().length();
        }
        char[] buf = new char[length];
        buf[0] = 40;
        int index = 1;
        for (int i2 = 0; i2 < paramsLength; ++i2) {
            paramDesc = params[i2].toString();
            int paramDescLength = paramDesc.length();
            paramDesc.getChars(0, paramDescLength, buf, index);
            index += paramDescLength;
        }
        buf[index++] = 41;
        paramDesc = ret.toString();
        paramDesc.getChars(0, paramDesc.length(), buf, index);
        return new String(buf);
    }

    private static class External
    implements Externalizable {
        private String mDescriptor;

        public External() {
        }

        public External(String desc) {
            this.mDescriptor = desc;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.mDescriptor);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.mDescriptor = in.readUTF();
        }

        public Object readResolve() throws ObjectStreamException {
            return MethodDesc.forDescriptor(this.mDescriptor);
        }
    }
}

