/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.LocationRange;

class LocationRangeImpl
implements LocationRange {
    private final Location mStart;
    private final Location mEnd;

    LocationRangeImpl(Location a, Location b) {
        if (a.compareTo(b) <= 0) {
            this.mStart = a;
            this.mEnd = b;
        } else {
            this.mStart = b;
            this.mEnd = a;
        }
    }

    LocationRangeImpl(LocationRange a, LocationRange b) {
        this.mStart = a.getStartLocation().compareTo(b.getStartLocation()) <= 0 ? a.getStartLocation() : b.getStartLocation();
        this.mEnd = b.getEndLocation().compareTo(a.getEndLocation()) >= 0 ? b.getEndLocation() : a.getEndLocation();
    }

    @Override
    public Location getStartLocation() {
        return this.mStart;
    }

    @Override
    public Location getEndLocation() {
        return this.mEnd;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        LocationRange other = (LocationRange)obj;
        int result = this.getStartLocation().compareTo(other.getStartLocation());
        if (result == 0) {
            result = this.getEndLocation().compareTo(other.getEndLocation());
        }
        return result;
    }

    public String toString() {
        int end;
        int start = this.getStartLocation().getLocation();
        if (start == (end = this.getEndLocation().getLocation() - 1)) {
            return String.valueOf(start);
        }
        return start + ".." + end;
    }
}

