/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.teatrove.trove.classfile.CodeBuffer;
import org.teatrove.trove.classfile.ConstantFieldInfo;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantInterfaceMethodInfo;
import org.teatrove.trove.classfile.ConstantMethodInfo;
import org.teatrove.trove.classfile.ExceptionHandler;
import org.teatrove.trove.classfile.Label;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.LocationRange;
import org.teatrove.trove.classfile.LocationRangeImpl;
import org.teatrove.trove.classfile.Opcode;
import org.teatrove.trove.classfile.TypeDesc;

class InstructionList
implements CodeBuffer {
    private static final boolean DEBUG = false;
    Instruction mFirst;
    Instruction mLast;
    boolean mResolved = false;
    private List mExceptionHandlers = new ArrayList(4);
    private List mLocalVariables = new ArrayList();
    private int mMaxStack;
    private int mMaxLocals;
    private byte[] mByteCodes;
    private int mBufferLength;

    protected InstructionList() {
    }

    public Collection getInstructions() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    private Instruction mNext;
                    {
                        this.mNext = InstructionList.this.mFirst;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mNext != null;
                    }

                    public Object next() {
                        if (this.mNext == null) {
                            throw new NoSuchElementException();
                        }
                        Instruction current = this.mNext;
                        this.mNext = this.mNext.mNext;
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                int count = 0;
                Instruction i = InstructionList.this.mFirst;
                while (i != null) {
                    ++count;
                    i = i.mNext;
                }
                return count;
            }
        };
    }

    @Override
    public int getMaxStackDepth() {
        this.resolve();
        return this.mMaxStack;
    }

    @Override
    public int getMaxLocals() {
        this.resolve();
        return this.mMaxLocals;
    }

    @Override
    public byte[] getByteCodes() {
        this.resolve();
        return this.mByteCodes;
    }

    @Override
    public ExceptionHandler[] getExceptionHandlers() {
        this.resolve();
        ExceptionHandler[] handlers = new ExceptionHandler[this.mExceptionHandlers.size()];
        return this.mExceptionHandlers.toArray(handlers);
    }

    public void addExceptionHandler(ExceptionHandler handler) {
        this.mExceptionHandlers.add(handler);
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        LocalVariableImpl var = new LocalVariableImpl(name, type, -1);
        this.mLocalVariables.add(var);
        return var;
    }

    public LocalVariable createLocalParameter(String name, TypeDesc type, int number) {
        LocalVariableImpl var = new LocalVariableImpl(name, type, number);
        this.mLocalVariables.add(var);
        if (this.mFirst == null) {
            LabelInstruction label = new LabelInstruction();
            label.setLocation();
            this.mFirst = label;
        }
        var.addStoreInstruction(this.mFirst);
        return var;
    }

    private void resolve() {
        if (this.mResolved) {
            return;
        }
        this.resolve0();
    }

    private void resolve0() {
        boolean passAgain;
        this.mMaxStack = 0;
        this.mMaxLocals = 0;
        int instrCount = 0;
        Instruction instr = this.mFirst;
        while (instr != null) {
            instr.mStackDepth = -1;
            instr.mLocation = instrCount++;
            instr = instr.mNext;
        }
        int size = this.mLocalVariables.size();
        for (int i = 0; i < size; ++i) {
            int max;
            LocalVariableImpl var = (LocalVariableImpl)this.mLocalVariables.get(i);
            if (var.getNumber() < 0) {
                var.setNumber(this.mMaxLocals);
            }
            if ((max = var.getNumber() + (var.isDoubleWord() ? 2 : 1)) <= this.mMaxLocals) continue;
            this.mMaxLocals = max;
        }
        HashMap subAdjustMap = new HashMap(11);
        this.stackResolve(0, this.mFirst, subAdjustMap);
        for (ExceptionHandler handler : this.mExceptionHandlers) {
            Instruction enter = (Instruction)handler.getCatchLocation();
            this.stackResolve(1, enter, subAdjustMap);
        }
        do {
            passAgain = false;
            this.mByteCodes = new byte[16];
            this.mBufferLength = 0;
            instr = this.mFirst;
            while (instr != null) {
                if (!instr.isResolved()) {
                    passAgain = true;
                }
                if (instr instanceof Label) {
                    if (instr.mLocation != this.mBufferLength) {
                        if (instr.mLocation >= 0) {
                            passAgain = true;
                        }
                        instr.mLocation = this.mBufferLength;
                    }
                } else {
                    instr.mLocation = this.mBufferLength;
                    byte[] bytes = instr.getBytes();
                    if (bytes != null) {
                        if (passAgain) {
                            this.mBufferLength += bytes.length;
                        } else {
                            this.addBytes(bytes);
                        }
                    }
                }
                instr = instr.mNext;
            }
        } while (passAgain);
        if (this.mBufferLength != this.mByteCodes.length) {
            byte[] newBytes = new byte[this.mBufferLength];
            System.arraycopy(this.mByteCodes, 0, newBytes, 0, this.mBufferLength);
            this.mByteCodes = newBytes;
        }
        this.mResolved = true;
    }

    private void addBytes(byte[] code) {
        this.growBuffer(code.length);
        System.arraycopy(code, 0, this.mByteCodes, this.mBufferLength, code.length);
        this.mBufferLength += code.length;
    }

    private void growBuffer(int amount) {
        if (this.mBufferLength + amount > this.mByteCodes.length) {
            int newCapacity = this.mByteCodes.length * 2;
            if (this.mBufferLength + amount > newCapacity) {
                newCapacity = this.mBufferLength + amount;
            }
            byte[] newBuffer = new byte[newCapacity];
            System.arraycopy(this.mByteCodes, 0, newBuffer, 0, this.mBufferLength);
            this.mByteCodes = newBuffer;
        }
    }

    private boolean variableResolve(LocalVariableImpl var, Instruction instr, SortedSet<Location> activeLocations, SortedSet<Location> possibleLocations, boolean fork) {
        while (instr != null) {
            if (activeLocations.contains(instr)) {
                activeLocations.addAll(possibleLocations);
                if (possibleLocations.isEmpty()) {
                    return false;
                }
                possibleLocations.clear();
                return true;
            }
            if (possibleLocations.contains(instr)) {
                return false;
            }
            possibleLocations.add(instr);
            if (instr instanceof LocalOperandInstruction && ((LocalOperandInstruction)instr).getLocalVariable() == var) {
                if (instr instanceof StoreLocalInstruction) {
                    activeLocations.add(instr);
                    if (fork) {
                        possibleLocations.remove(instr);
                    } else {
                        possibleLocations.clear();
                    }
                } else {
                    activeLocations.addAll(possibleLocations);
                    possibleLocations.clear();
                }
            }
            Instruction next = null;
            if (instr.isFlowThrough() && (next = instr.mNext) == null) {
                this.printInstructions("execution flows through end of method");
                throw new RuntimeException("Execution flows through end of method");
            }
            Location[] targets = instr.getBranchTargets();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    LabelInstruction targetInstr = (LabelInstruction)targets[i];
                    if (i == 0 && next == null) {
                        next = targetInstr;
                        continue;
                    }
                    this.variableResolve(var, targetInstr, activeLocations, possibleLocations, true);
                }
            }
            instr = next;
        }
        return true;
    }

    private int stackResolve(int stackDepth, Instruction instr, Map subAdjustMap) {
        while (instr != null) {
            if (instr.mStackDepth >= 0) {
                if (instr.mStackDepth == stackDepth) break;
                this.printInstructions("invalid stack depth");
                throw new RuntimeException("Stack depth different at previously visited instruction: " + instr.mStackDepth + " != " + stackDepth);
            }
            instr.mStackDepth = stackDepth;
            Instruction next = null;
            if (instr.isFlowThrough() && (next = instr.mNext) == null) {
                this.printInstructions("execution flows through end of method");
                throw new RuntimeException("Execution flows through end of method");
            }
            if ((stackDepth += instr.getStackAdjustment()) > this.mMaxStack) {
                this.mMaxStack = stackDepth;
            } else if (stackDepth < 0) {
                this.printInstructions("invalid stack depth");
                throw new RuntimeException("Stack depth is negative: " + stackDepth);
            }
            Location[] targets = instr.getBranchTargets();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    LabelInstruction targetInstr = (LabelInstruction)targets[i];
                    if (i == 0 && next == null) {
                        next = targetInstr;
                        continue;
                    }
                    if (!instr.isSubroutineCall()) {
                        this.stackResolve(stackDepth, targetInstr, subAdjustMap);
                        continue;
                    }
                    Integer subAdjust = (Integer)subAdjustMap.get(targetInstr);
                    if (subAdjust == null) {
                        int newDepth = this.stackResolve(stackDepth, targetInstr, subAdjustMap);
                        subAdjust = new Integer(newDepth - stackDepth);
                        subAdjustMap.put(targetInstr, subAdjust);
                    }
                    stackDepth += subAdjust.intValue();
                }
            }
            instr = next;
        }
        return stackDepth;
    }

    private void printInstructions(String errorMsg) {
        System.err.println("Error generating instructions: " + errorMsg);
        System.err.println("-- Instructions --");
        Iterator it = this.getInstructions().iterator();
        while (it.hasNext()) {
            System.err.println(it.next().toString());
        }
    }

    public class SwitchInstruction
    extends CodeInstruction {
        private int[] mCases;
        private Location[] mLocations;
        private Location mDefaultLocation;
        private byte mOpcode;
        private int mSmallest;
        private int mLargest;

        public SwitchInstruction(int[] casesParam, Location[] locationsParam, Location defaultLocation) {
            super(-1);
            if (casesParam.length != locationsParam.length) {
                InstructionList.this.printInstructions("switch cases and location sizes differ");
                throw new IllegalArgumentException("Switch cases and locations sizes differ: " + casesParam.length + ", " + locationsParam.length);
            }
            this.mCases = new int[casesParam.length];
            System.arraycopy(casesParam, 0, this.mCases, 0, casesParam.length);
            this.mLocations = new Location[locationsParam.length];
            System.arraycopy(locationsParam, 0, this.mLocations, 0, locationsParam.length);
            this.mDefaultLocation = defaultLocation;
            this.sort(0, this.mCases.length - 1);
            int lastCase = 0;
            for (int i = 0; i < this.mCases.length; ++i) {
                if (i > 0 && this.mCases[i] == lastCase) {
                    InstructionList.this.printInstructions("duplicate switch cases");
                    throw new RuntimeException("Duplicate switch cases: " + lastCase);
                }
                lastCase = this.mCases[i];
            }
            this.mSmallest = this.mCases[0];
            this.mLargest = this.mCases[this.mCases.length - 1];
            int tSize = 12 + 4 * (this.mLargest - this.mSmallest + 1);
            int lSize = 8 + 8 * this.mCases.length;
            this.mOpcode = tSize <= lSize ? (byte)-86 : (byte)-85;
        }

        @Override
        public Location[] getBranchTargets() {
            Location[] targets = new Location[this.mLocations.length + 1];
            System.arraycopy(this.mLocations, 0, targets, 0, this.mLocations.length);
            targets[targets.length - 1] = this.mDefaultLocation;
            return targets;
        }

        @Override
        public boolean isFlowThrough() {
            return false;
        }

        @Override
        public byte[] getBytes() {
            int length = 1;
            int pad = 3 - (this.mLocation & 3);
            length += pad;
            length = this.mOpcode == -86 ? (length += 12 + 4 * (this.mLargest - this.mSmallest + 1)) : (length += 8 + 8 * this.mCases.length);
            this.mBytes = new byte[length];
            if (!this.isResolved()) {
                return this.mBytes;
            }
            this.mBytes[0] = this.mOpcode;
            int cursor = pad + 1;
            int defaultOffset = this.mDefaultLocation.getLocation() - this.mLocation;
            this.mBytes[cursor++] = (byte)(defaultOffset >> 24);
            this.mBytes[cursor++] = (byte)(defaultOffset >> 16);
            this.mBytes[cursor++] = (byte)(defaultOffset >> 8);
            this.mBytes[cursor++] = (byte)(defaultOffset >> 0);
            if (this.mOpcode == -86) {
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 24);
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 16);
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 8);
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 0);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 24);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 16);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 8);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 0);
                int index = 0;
                for (int case_ = this.mSmallest; case_ <= this.mLargest; ++case_) {
                    if (case_ == this.mCases[index]) {
                        int offset = this.mLocations[index].getLocation() - this.mLocation;
                        this.mBytes[cursor++] = (byte)(offset >> 24);
                        this.mBytes[cursor++] = (byte)(offset >> 16);
                        this.mBytes[cursor++] = (byte)(offset >> 8);
                        this.mBytes[cursor++] = (byte)(offset >> 0);
                        ++index;
                        continue;
                    }
                    this.mBytes[cursor++] = (byte)(defaultOffset >> 24);
                    this.mBytes[cursor++] = (byte)(defaultOffset >> 16);
                    this.mBytes[cursor++] = (byte)(defaultOffset >> 8);
                    this.mBytes[cursor++] = (byte)(defaultOffset >> 0);
                }
            } else {
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 24);
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 16);
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 8);
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 0);
                for (int index = 0; index < this.mCases.length; ++index) {
                    int case_ = this.mCases[index];
                    this.mBytes[cursor++] = (byte)(case_ >> 24);
                    this.mBytes[cursor++] = (byte)(case_ >> 16);
                    this.mBytes[cursor++] = (byte)(case_ >> 8);
                    this.mBytes[cursor++] = (byte)(case_ >> 0);
                    int offset = this.mLocations[index].getLocation() - this.mLocation;
                    this.mBytes[cursor++] = (byte)(offset >> 24);
                    this.mBytes[cursor++] = (byte)(offset >> 16);
                    this.mBytes[cursor++] = (byte)(offset >> 8);
                    this.mBytes[cursor++] = (byte)(offset >> 0);
                }
            }
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            if (this.mDefaultLocation.getLocation() >= 0) {
                for (int i = 0; i < this.mLocations.length && this.mLocations[i].getLocation() >= 0; ++i) {
                }
                return true;
            }
            return false;
        }

        private void sort(int left, int right) {
            if (left >= right) {
                return;
            }
            this.swap(left, (left + right) / 2);
            int last = left;
            for (int i = left + 1; i <= right; ++i) {
                if (this.mCases[i] >= this.mCases[left]) continue;
                this.swap(++last, i);
            }
            this.swap(left, last);
            this.sort(left, last - 1);
            this.sort(last + 1, right);
        }

        private void swap(int i, int j) {
            int tempInt = this.mCases[i];
            this.mCases[i] = this.mCases[j];
            this.mCases[j] = tempInt;
            Location tempLocation = this.mLocations[i];
            this.mLocations[i] = this.mLocations[j];
            this.mLocations[j] = tempLocation;
        }
    }

    public class ShortIncrementInstruction
    extends LocalOperandInstruction {
        private short mAmount;

        public ShortIncrementInstruction(LocalVariable local, short amount) {
            super(0, local);
            this.mAmount = amount;
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            int varNum = this.getVariableNumber();
            this.mBytes = -128 <= this.mAmount && this.mAmount <= 127 && varNum <= 255 ? new byte[]{-124, (byte)varNum, (byte)this.mAmount} : new byte[]{-60, -124, (byte)(varNum >> 8), (byte)varNum, (byte)(this.mAmount >> 8), (byte)this.mAmount};
            return this.mBytes;
        }
    }

    public class RetInstruction
    extends LocalOperandInstruction {
        public RetInstruction(LocalVariable local) {
            super(0, local);
        }

        @Override
        public boolean isFlowThrough() {
            return false;
        }

        @Override
        public byte[] getBytes() {
            int varNum = this.getVariableNumber();
            this.mBytes = varNum <= 255 ? new byte[]{-87, (byte)varNum} : new byte[]{-60, -87, (byte)(varNum >> 8), (byte)varNum};
            return this.mBytes;
        }
    }

    public class StoreLocalInstruction
    extends LocalOperandInstruction {
        public StoreLocalInstruction(int stackAdjust, LocalVariable local) {
            super(stackAdjust, local);
            ((LocalVariableImpl)local).addStoreInstruction(this);
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            byte opcode;
            int varNum = this.getVariableNumber();
            boolean writeIndex = false;
            int typeCode = this.mLocal.getType().getTypeCode();
            block0 : switch (varNum) {
                case 0: {
                    switch (typeCode) {
                        default: {
                            opcode = 75;
                            break block0;
                        }
                        case 11: {
                            opcode = 63;
                            break block0;
                        }
                        case 6: {
                            opcode = 67;
                            break block0;
                        }
                        case 7: {
                            opcode = 71;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 59;
                    break;
                }
                case 1: {
                    switch (typeCode) {
                        default: {
                            opcode = 76;
                            break block0;
                        }
                        case 11: {
                            opcode = 64;
                            break block0;
                        }
                        case 6: {
                            opcode = 68;
                            break block0;
                        }
                        case 7: {
                            opcode = 72;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 60;
                    break;
                }
                case 2: {
                    switch (typeCode) {
                        default: {
                            opcode = 77;
                            break block0;
                        }
                        case 11: {
                            opcode = 65;
                            break block0;
                        }
                        case 6: {
                            opcode = 69;
                            break block0;
                        }
                        case 7: {
                            opcode = 73;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 61;
                    break;
                }
                case 3: {
                    switch (typeCode) {
                        default: {
                            opcode = 78;
                            break block0;
                        }
                        case 11: {
                            opcode = 66;
                            break block0;
                        }
                        case 6: {
                            opcode = 70;
                            break block0;
                        }
                        case 7: {
                            opcode = 74;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 62;
                    break;
                }
                default: {
                    writeIndex = true;
                    switch (typeCode) {
                        default: {
                            opcode = 58;
                            break block0;
                        }
                        case 11: {
                            opcode = 55;
                            break block0;
                        }
                        case 6: {
                            opcode = 56;
                            break block0;
                        }
                        case 7: {
                            opcode = 57;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 54;
                }
            }
            this.mBytes = !writeIndex ? new byte[]{opcode} : (varNum <= 255 ? new byte[]{opcode, (byte)varNum} : new byte[]{-60, opcode, (byte)(varNum >> 8), (byte)varNum});
            return this.mBytes;
        }
    }

    public class LoadLocalInstruction
    extends LocalOperandInstruction {
        public LoadLocalInstruction(int stackAdjust, LocalVariable local) {
            super(stackAdjust, local);
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            byte opcode;
            int varNum = this.getVariableNumber();
            boolean writeIndex = false;
            int typeCode = this.mLocal.getType().getTypeCode();
            block0 : switch (varNum) {
                case 0: {
                    switch (typeCode) {
                        default: {
                            opcode = 42;
                            break block0;
                        }
                        case 11: {
                            opcode = 30;
                            break block0;
                        }
                        case 6: {
                            opcode = 34;
                            break block0;
                        }
                        case 7: {
                            opcode = 38;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 26;
                    break;
                }
                case 1: {
                    switch (typeCode) {
                        default: {
                            opcode = 43;
                            break block0;
                        }
                        case 11: {
                            opcode = 31;
                            break block0;
                        }
                        case 6: {
                            opcode = 35;
                            break block0;
                        }
                        case 7: {
                            opcode = 39;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 27;
                    break;
                }
                case 2: {
                    switch (typeCode) {
                        default: {
                            opcode = 44;
                            break block0;
                        }
                        case 11: {
                            opcode = 32;
                            break block0;
                        }
                        case 6: {
                            opcode = 36;
                            break block0;
                        }
                        case 7: {
                            opcode = 40;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 28;
                    break;
                }
                case 3: {
                    switch (typeCode) {
                        default: {
                            opcode = 45;
                            break block0;
                        }
                        case 11: {
                            opcode = 33;
                            break block0;
                        }
                        case 6: {
                            opcode = 37;
                            break block0;
                        }
                        case 7: {
                            opcode = 41;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 29;
                    break;
                }
                default: {
                    writeIndex = true;
                    switch (typeCode) {
                        default: {
                            opcode = 25;
                            break block0;
                        }
                        case 11: {
                            opcode = 22;
                            break block0;
                        }
                        case 6: {
                            opcode = 23;
                            break block0;
                        }
                        case 7: {
                            opcode = 24;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 21;
                }
            }
            this.mBytes = !writeIndex ? new byte[]{opcode} : (varNum <= 255 ? new byte[]{opcode, (byte)varNum} : new byte[]{-60, opcode, (byte)(varNum >> 8), (byte)varNum});
            return this.mBytes;
        }
    }

    public class LocalOperandInstruction
    extends CodeInstruction {
        protected LocalVariable mLocal;

        public LocalOperandInstruction(int stackAdjust, LocalVariable local) {
            super(stackAdjust);
            this.mLocal = local;
        }

        @Override
        public boolean isResolved() {
            return this.mLocal.getNumber() >= 0;
        }

        public LocalVariable getLocalVariable() {
            return this.mLocal;
        }

        public int getVariableNumber() {
            int varNum = this.mLocal.getNumber();
            if (varNum < 0) {
                InstructionList.this.printInstructions("local variable number not resolved");
                throw new RuntimeException("Local variable number not resolved");
            }
            return varNum;
        }
    }

    public class LoadConstantInstruction
    extends CodeInstruction {
        private ConstantInfo mInfo;
        private boolean mWideOnly;

        public LoadConstantInstruction(int stackAdjust, ConstantInfo info) {
            this(stackAdjust, info, false);
        }

        public LoadConstantInstruction(int stackAdjust, ConstantInfo info, boolean wideOnly) {
            super(stackAdjust);
            this.mInfo = info;
            this.mWideOnly = wideOnly;
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            int index = this.mInfo.getIndex();
            if (index < 0) {
                InstructionList.this.printInstructions("constant pool index not resolved");
                throw new RuntimeException("Constant pool index not resolved");
            }
            if (this.mWideOnly) {
                byte[] bytes = new byte[]{20, (byte)(index >> 8), (byte)index};
                return bytes;
            }
            if (index <= 255) {
                byte[] bytes = new byte[]{18, (byte)index};
                return bytes;
            }
            byte[] bytes = new byte[]{19, (byte)(index >> 8), (byte)index};
            return bytes;
        }

        @Override
        public boolean isResolved() {
            return this.mInfo.getIndex() >= 0;
        }
    }

    public class ConstantOperandInstruction
    extends CodeInstruction {
        private ConstantInfo mInfo;

        public ConstantOperandInstruction(int stackAdjust, byte[] bytes, ConstantInfo info) {
            super(stackAdjust, bytes);
            this.mInfo = info;
        }

        @Override
        public byte[] getBytes() {
            int index = this.mInfo.getIndex();
            if (index < 0) {
                InstructionList.this.printInstructions("constant pool index not resolved");
                throw new RuntimeException("Constant pool index not resolved");
            }
            this.mBytes[1] = (byte)(index >> 8);
            this.mBytes[2] = (byte)index;
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return this.mInfo.getIndex() >= 0;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(super.toString()).append(' ');
            if (this.mInfo instanceof ConstantMethodInfo) {
                ConstantMethodInfo info = (ConstantMethodInfo)this.mInfo;
                buffer.append(info.getNameAndType().getName()).append(info.getNameAndType().getType());
            } else if (this.mInfo instanceof ConstantInterfaceMethodInfo) {
                ConstantInterfaceMethodInfo info = (ConstantInterfaceMethodInfo)this.mInfo;
                buffer.append(info.getNameAndType().getName()).append(info.getNameAndType().getType());
            } else if (this.mInfo instanceof ConstantFieldInfo) {
                ConstantFieldInfo info = (ConstantFieldInfo)this.mInfo;
                buffer.append(info.getNameAndType().getType()).append(' ').append(info.getNameAndType().getName());
            }
            return buffer.toString();
        }
    }

    public class BranchInstruction
    extends CodeInstruction {
        private Location mTarget;
        private boolean mHasShortHop;
        private boolean mIsSub;

        public BranchInstruction(int stackAdjust, byte opcode, Location target) {
            this(stackAdjust, true, opcode, target);
        }

        private BranchInstruction(int stackAdjust, boolean addInstruction, byte opcode, Location target) {
            super(stackAdjust, addInstruction);
            this.mHasShortHop = false;
            this.mIsSub = false;
            this.mTarget = target;
            switch (opcode) {
                case -56: 
                case -55: {
                    this.mIsSub = true;
                    this.mBytes = new byte[5];
                    this.mBytes[0] = opcode;
                    break;
                }
                case -88: {
                    this.mIsSub = true;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -58: 
                case -57: {
                    this.mBytes = new byte[3];
                    this.mBytes[0] = opcode;
                    break;
                }
                default: {
                    InstructionList.this.printInstructions("opcode not a branch instruction");
                    throw new IllegalArgumentException("Opcode not a branch instruction: " + Opcode.getMnemonic(opcode));
                }
            }
        }

        @Override
        public Location[] getBranchTargets() {
            return new Location[]{this.mTarget};
        }

        @Override
        public boolean isSubroutineCall() {
            return this.mIsSub;
        }

        @Override
        public byte[] getBytes() {
            if (!this.isResolved() || this.mHasShortHop) {
                return this.mBytes;
            }
            int offset = this.mTarget.getLocation() - this.mLocation;
            byte opcode = this.mBytes[0];
            if (opcode == -56 || opcode == -55) {
                this.mBytes[1] = (byte)(offset >> 24);
                this.mBytes[2] = (byte)(offset >> 16);
                this.mBytes[3] = (byte)(offset >> 8);
                this.mBytes[4] = (byte)(offset >> 0);
            } else if (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE) {
                this.mBytes[1] = (byte)(offset >> 8);
                this.mBytes[2] = (byte)(offset >> 0);
            } else if (opcode == -89 || opcode == -88) {
                this.mBytes = new byte[5];
                this.mBytes[0] = opcode == -89 ? -56 : -55;
                this.mBytes[1] = (byte)(offset >> 24);
                this.mBytes[2] = (byte)(offset >> 16);
                this.mBytes[3] = (byte)(offset >> 8);
                this.mBytes[4] = (byte)(offset >> 0);
            } else {
                this.mHasShortHop = true;
                this.mBytes[0] = opcode = Opcode.reverseIfOpcode(opcode);
                this.mBytes[1] = 0;
                this.mBytes[2] = 8;
                this.insert(new BranchInstruction(0, false, -56, this.mTarget));
            }
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return this.mTarget.getLocation() >= 0;
        }
    }

    public class CodeInstruction
    extends Instruction {
        protected byte[] mBytes;

        public CodeInstruction(int stackAdjust) {
            super(stackAdjust);
        }

        protected CodeInstruction(int stackAdjust, boolean addInstruction) {
            super(stackAdjust, addInstruction);
        }

        public CodeInstruction(int stackAdjust, byte b) {
            super(stackAdjust);
            this.mBytes = new byte[]{b};
        }

        public CodeInstruction(int stackAdjust, byte[] bytes) {
            super(stackAdjust);
            this.mBytes = bytes;
        }

        @Override
        public boolean isFlowThrough() {
            if (this.mBytes != null && this.mBytes.length > 0) {
                switch (this.mBytes[0]) {
                    case -89: 
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: 
                    case -65: 
                    case -56: {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public byte[] getBytes() {
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return true;
        }
    }

    public class LabelInstruction
    extends Instruction
    implements Label {
        public LabelInstruction() {
            super(0, false);
        }

        @Override
        public Label setLocation() {
            this.add();
            return this;
        }

        @Override
        public int getLocation() throws IllegalStateException {
            int loc = this.mLocation;
            if (loc < 0 && this.mPrev == null && this.mNext == null) {
                InstructionList.this.printInstructions("label location not set");
                throw new IllegalStateException("Label location is not set");
            }
            return loc;
        }

        @Override
        public byte[] getBytes() {
            return null;
        }

        @Override
        public boolean isResolved() {
            return this.getLocation() >= 0;
        }
    }

    public abstract class Instruction
    implements Location {
        private int mStackAdjust;
        Instruction mPrev;
        Instruction mNext;
        int mStackDepth = -1;
        int mLocation = -1;

        public Instruction(int stackAdjust) {
            this.mStackAdjust = stackAdjust;
            this.add();
        }

        protected Instruction(int stackAdjust, boolean addInstruction) {
            this.mStackAdjust = stackAdjust;
            if (addInstruction) {
                this.add();
            }
        }

        protected void add() {
            InstructionList.this.mResolved = false;
            if (this.mPrev != null) {
                this.mPrev.mNext = this.mNext;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = this.mPrev;
            }
            this.mNext = null;
            if (InstructionList.this.mFirst == null) {
                this.mPrev = null;
                InstructionList.this.mFirst = this;
            } else {
                this.mPrev = InstructionList.this.mLast;
                InstructionList.this.mLast.mNext = this;
            }
            InstructionList.this.mLast = this;
        }

        public void insert(Instruction instr) {
            InstructionList.this.mResolved = false;
            instr.mPrev = this;
            instr.mNext = this.mNext;
            this.mNext = instr;
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = instr;
            }
        }

        public void remove() {
            InstructionList.this.mResolved = false;
            if (this.mPrev != null) {
                this.mPrev.mNext = this.mNext;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = this.mPrev;
            }
            if (this == InstructionList.this.mFirst) {
                InstructionList.this.mFirst = this.mNext;
            }
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = this.mPrev;
            }
            this.mPrev = null;
            this.mNext = null;
        }

        public void replace(Instruction replacement) {
            if (replacement == null) {
                this.remove();
                return;
            }
            InstructionList.this.mResolved = false;
            replacement.mPrev = this.mPrev;
            replacement.mNext = this.mNext;
            if (this.mPrev != null) {
                this.mPrev.mNext = replacement;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = replacement;
            }
            if (this == InstructionList.this.mFirst) {
                InstructionList.this.mFirst = replacement;
            }
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = replacement;
            }
        }

        public int getStackAdjustment() {
            return this.mStackAdjust;
        }

        public int getStackDepth() {
            return this.mStackDepth;
        }

        @Override
        public int getLocation() {
            return this.mLocation;
        }

        public Location[] getBranchTargets() {
            return null;
        }

        public boolean isFlowThrough() {
            return true;
        }

        public boolean isSubroutineCall() {
            return false;
        }

        public abstract byte[] getBytes();

        public abstract boolean isResolved();

        public int compareTo(Object obj) {
            int locb;
            if (this == obj) {
                return 0;
            }
            Location other = (Location)obj;
            int loca = this.getLocation();
            if (loca < (locb = other.getLocation())) {
                return -1;
            }
            if (loca > locb) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            String name = this.getClass().getName();
            int index = name.lastIndexOf(46);
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            if ((index = name.lastIndexOf(36)) >= 0) {
                name = name.substring(index + 1);
            }
            StringBuffer buf = new StringBuffer(name.length() + 20);
            int adjust = this.getStackAdjustment();
            int depth = this.getStackDepth();
            if (depth >= 0) {
                buf.append(' ');
            } else {
                buf.append('*');
            }
            buf.append('[');
            buf.append(this.mLocation);
            buf.append("] ");
            buf.append(name);
            buf.append(" (");
            if (depth >= 0) {
                buf.append(depth);
                buf.append(" + ");
                buf.append(adjust);
                buf.append(" = ");
                buf.append(depth + adjust);
            } else {
                buf.append(adjust);
            }
            buf.append(") ");
            try {
                byte[] bytes = this.getBytes();
                boolean wide = false;
                if (bytes != null) {
                    for (int i = 0; i < bytes.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        byte code = bytes[i];
                        if (i == 0 || wide) {
                            buf.append(Opcode.getMnemonic(code));
                            wide = code == -60;
                            continue;
                        }
                        buf.append(code & 0xFF);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            buf.append(" [").append(this.isFlowThrough()).append(']');
            return buf.toString();
        }
    }

    private class LocalVariableImpl
    implements LocalVariable {
        private String mName;
        private TypeDesc mType;
        private int mNumber;
        private boolean mFixed;
        private List mStoreInstructions;
        private SortedSet<LocationRange> mLocationRangeSet;

        public LocalVariableImpl(String name, TypeDesc type, int number) {
            this.mName = name;
            this.mType = type;
            this.mNumber = number;
            if (number >= 0) {
                this.mFixed = true;
            }
            this.mStoreInstructions = new ArrayList();
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public void setName(String name) {
            this.mName = name;
        }

        @Override
        public TypeDesc getType() {
            return this.mType;
        }

        @Override
        public boolean isDoubleWord() {
            return this.mType.isDoubleWord();
        }

        @Override
        public int getNumber() {
            return this.mNumber;
        }

        public void setNumber(int number) {
            this.mNumber = number;
        }

        @Override
        public SortedSet<LocationRange> getLocationRangeSet() {
            return this.mLocationRangeSet;
        }

        public void setLocations(Set<Location> locations) {
            List<Location> sortedLocations = Collections.checkedList(new ArrayList(), Location.class);
            sortedLocations.addAll(locations);
            Collections.sort(sortedLocations);
            this.mLocationRangeSet = new TreeSet<LocationRange>();
            Instruction first = null;
            Instruction last = null;
            for (Location sortedLocation : sortedLocations) {
                Instruction instr = (Instruction)sortedLocation;
                if (first == null) {
                    first = last = instr;
                    continue;
                }
                if (last.mNext == instr) {
                    last = instr;
                    continue;
                }
                if (last.mNext != null) {
                    last = last.mNext;
                }
                this.mLocationRangeSet.add(new LocationRangeImpl(first, last));
                first = last = instr;
            }
            if (first != null && last != null) {
                if (last.mNext != null) {
                    last = last.mNext;
                }
                this.mLocationRangeSet.add(new LocationRangeImpl(first, last));
            }
            this.mLocationRangeSet = Collections.unmodifiableSortedSet(this.mLocationRangeSet);
        }

        public boolean isFixedNumber() {
            return this.mFixed;
        }

        public void addStoreInstruction(Instruction instr) {
            this.mStoreInstructions.add(instr);
        }

        public Iterator iterateStoreInstructions() {
            return this.mStoreInstructions.iterator();
        }

        public String toString() {
            if (this.getName() != null) {
                return String.valueOf(this.getType()) + ' ' + this.getName();
            }
            return String.valueOf(this.getType());
        }
    }
}

