/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.AttributeFactory;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.ConstantDoubleInfo;
import org.teatrove.trove.classfile.ConstantFloatInfo;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantIntegerInfo;
import org.teatrove.trove.classfile.ConstantLongInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantStringInfo;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.ConstantValueAttr;
import org.teatrove.trove.classfile.DeprecatedAttr;
import org.teatrove.trove.classfile.Modifiers;
import org.teatrove.trove.classfile.SyntheticAttr;
import org.teatrove.trove.classfile.TypeDesc;

public class FieldInfo {
    private ClassFile mParent;
    private ConstantPool mCp;
    private String mName;
    private TypeDesc mType;
    private int mModifier;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;
    private List mAttributes = new ArrayList(2);
    private ConstantValueAttr mConstant;

    FieldInfo(ClassFile parent, Modifiers modifiers, String name, TypeDesc type) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = name;
        this.mType = type;
        this.mModifier = modifiers.getModifier();
        this.mNameConstant = ConstantUTFInfo.make(this.mCp, name);
        this.mDescriptorConstant = ConstantUTFInfo.make(this.mCp, type.toString());
    }

    private FieldInfo(ClassFile parent, int modifier, ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = nameConstant.getValue();
        this.mType = TypeDesc.forDescriptor(descConstant.getValue());
        this.mModifier = modifier;
        this.mNameConstant = nameConstant;
        this.mDescriptorConstant = descConstant;
    }

    public ClassFile getClassFile() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public TypeDesc getType() {
        return this.mType;
    }

    public Modifiers getModifiers() {
        return new Modifiers(this.mModifier);
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public ConstantUTFInfo getDescriptorConstant() {
        return this.mDescriptorConstant;
    }

    public ConstantInfo getConstantValue() {
        if (this.mConstant == null) {
            return null;
        }
        return this.mConstant.getConstant();
    }

    public boolean isSynthetic() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Object obj = this.mAttributes.get(i);
            if (!(obj instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Object obj = this.mAttributes.get(i);
            if (!(obj instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public void setConstantValue(int value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantIntegerInfo.make(this.mCp, value)));
    }

    public void setConstantValue(float value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantFloatInfo.make(this.mCp, value)));
    }

    public void setConstantValue(long value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantLongInfo.make(this.mCp, value)));
    }

    public void setConstantValue(double value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantDoubleInfo.make(this.mCp, value)));
    }

    public void setConstantValue(String value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, ConstantStringInfo.make(this.mCp, value)));
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof ConstantValueAttr) {
            if (this.mConstant != null) {
                this.mAttributes.remove(this.mConstant);
            }
            this.mConstant = (ConstantValueAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        Attribute[] attrs = new Attribute[this.mAttributes.size()];
        return this.mAttributes.toArray(attrs);
    }

    public int getLength() {
        int length = 8;
        int size = this.mAttributes.size();
        for (int i = 0; i < size; ++i) {
            length += ((Attribute)this.mAttributes.get(i)).getLength();
        }
        return length;
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mModifier);
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeShort(this.mDescriptorConstant.getIndex());
        int size = this.mAttributes.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            Attribute attr = (Attribute)this.mAttributes.get(i);
            attr.writeTo(dout);
        }
    }

    public String toString() {
        String modStr = Modifier.toString(this.mModifier);
        if (modStr.length() == 0) {
            return this.mType.getFullName() + ' ' + this.getName();
        }
        return modStr + ' ' + this.mType.getFullName() + ' ' + this.getName();
    }

    static FieldInfo readFrom(ClassFile parent, DataInput din, AttributeFactory attrFactory) throws IOException {
        ConstantPool cp = parent.getConstantPool();
        int modifier = din.readUnsignedShort();
        int index = din.readUnsignedShort();
        ConstantUTFInfo nameConstant = (ConstantUTFInfo)cp.getConstant(index);
        index = din.readUnsignedShort();
        ConstantUTFInfo descConstant = (ConstantUTFInfo)cp.getConstant(index);
        FieldInfo info = new FieldInfo(parent, modifier, nameConstant, descConstant);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            info.addAttribute(Attribute.readFrom(cp, din, attrFactory));
        }
        return info;
    }
}

