/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;

public class ConstantDoubleInfo
extends ConstantInfo {
    private Double mValue;

    static ConstantDoubleInfo make(ConstantPool cp, double value) {
        ConstantDoubleInfo ci = new ConstantDoubleInfo(value);
        return (ConstantDoubleInfo)cp.addConstant(ci);
    }

    ConstantDoubleInfo(double value) {
        super(6);
        this.mValue = new Double(value);
    }

    ConstantDoubleInfo(Double value) {
        super(6);
        this.mValue = value;
    }

    public Double getValue() {
        return this.mValue;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantDoubleInfo) {
            ConstantDoubleInfo other = (ConstantDoubleInfo)obj;
            return this.mValue.equals(other.mValue);
        }
        return false;
    }

    @Override
    int getEntryCount() {
        return 2;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeDouble(this.mValue);
    }

    public String toString() {
        return "CONSTANT_Double_info: " + this.getValue();
    }
}

