/*
 * Decompiled with CFR 0.152.
 */
package scj.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import scj.result.Result;
import scj.result.TuplePair;
import scj.result.TupleResultList;

public class SynchronousTupleResultList
implements Result {
    public List<TuplePair> list = Collections.synchronizedList(new ArrayList());
    private static final long serialVersionUID = 1L;
    private boolean verbose;
    private String algName;

    public SynchronousTupleResultList() {
        this("", false);
    }

    public SynchronousTupleResultList(String algName, boolean verbose) {
        this.algName = algName;
        this.verbose = verbose;
    }

    @Override
    public void add(int r, int s) {
        TuplePair tp = new TuplePair(r, s);
        this.list.add(tp);
    }

    public void add(TuplePair tp) {
        this.list.add(tp);
    }

    @Override
    public void output() {
        if (!this.verbose) {
            return;
        }
        Iterator<TuplePair> it = this.list.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    @Override
    public void add(Result result) {
        if (result instanceof TupleResultList) {
            TupleResultList r = (TupleResultList)result;
            int i = 0;
            while (i < r.size()) {
                this.add((TuplePair)r.get(i));
                ++i;
            }
        }
    }

    @Override
    public Result getSubresult() {
        return new TupleResultList();
    }

    @Override
    public String getName() {
        return this.algName;
    }

    @Override
    public void setName(String name) {
        this.algName = name;
    }

    @Override
    public Result withName(String name) {
        this.setName(name);
        return this;
    }

    public Iterator<TuplePair> iterator() {
        return this.list.iterator();
    }
}

