/*
 * Decompiled with CFR 0.152.
 */
package scj.result;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import scj.result.Result;
import scj.result.TuplePair;

public class FileTupleResultList
extends ArrayList<TuplePair>
implements Result {
    private static final long serialVersionUID = 1L;
    private boolean verbose;
    private String algName;

    public FileTupleResultList() {
        this("", true);
    }

    public FileTupleResultList(String algName, boolean verbose) {
        this.algName = algName;
        this.verbose = verbose;
    }

    @Override
    public void add(int r, int s) {
        TuplePair tp = new TuplePair(r, s);
        this.add(tp);
    }

    @Override
    public void output() {
        if (!this.verbose) {
            return;
        }
        this.sort(new Comparator<TuplePair>(){

            @Override
            public int compare(TuplePair arg0, TuplePair arg1) {
                return arg0.compareTo(arg1);
            }
        });
        Iterator it = this.iterator();
        try {
            int validIndex = 1;
            while (new File("results" + validIndex + ".txt").exists()) {
                ++validIndex;
            }
            PrintWriter writer = new PrintWriter("results" + validIndex + ".txt", "UTF-8");
            while (it.hasNext()) {
                writer.print(it.next() + "\r\n");
            }
            writer.close();
        }
        catch (Exception e) {
            System.err.println("couldn't write results to file");
        }
    }

    @Override
    public void add(Result result) {
        if (result instanceof FileTupleResultList) {
            FileTupleResultList r = (FileTupleResultList)result;
            int i = 0;
            while (i < r.size()) {
                this.add((TuplePair)r.get(i));
                ++i;
            }
        }
    }

    @Override
    public Result getSubresult() {
        return new FileTupleResultList();
    }

    @Override
    public String getName() {
        return this.algName;
    }

    @Override
    public void setName(String name) {
        this.algName = name;
    }

    @Override
    public Result withName(String name) {
        this.setName(name);
        return this;
    }
}

