/*
 * Decompiled with CFR 0.152.
 */
package scj.input;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.input.DataTuple;

public abstract class InputReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputReader.class);

    protected abstract String getFilename();

    public Set<DataTuple>[] getDataTuples(int line_limit) {
        Set[] trees = new Set[]{this.getDataTupleSet(line_limit, this.getFilename(), true), this.getDataTupleSet(line_limit, this.getFilename(), true)};
        return trees;
    }

    public Set<DataTuple>[] getDataTuples() {
        Set[] trees = new Set[]{this.getDataTupleSet(-1, this.getFilename(), true), this.getDataTupleSet(-1, this.getFilename(), true)};
        return trees;
    }

    protected Set<DataTuple> getDataTupleSet(int line_limit, String filename, boolean hasFirstLineWithAdditionalInformation) {
        HashSet<DataTuple> data = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(System.getProperty("scjInputFolder", "")) + filename));
            if (hasFirstLineWithAdditionalInformation) {
                line = br.readLine();
                if (line != null) {
                    String[] contents = line.split(" ");
                    int numRelationEntries = Integer.valueOf(contents[0]);
                    data = new HashSet(numRelationEntries);
                }
            } else {
                data = new HashSet<DataTuple>();
            }
            int line_number = 0;
            while ((line = br.readLine()) != null) {
                if (line_limit > 0 && ++line_number >= line_limit) break;
                String content = this.getContentFromLine(line);
                if (content.trim().length() == 0) continue;
                Object[] stringset = content.split(this.getSplitString());
                int[] set = new int[stringset.length];
                int i = 0;
                while (i < stringset.length) {
                    try {
                        set[i] = Integer.parseInt(stringset[i]);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Parser problem in stringset: " + Arrays.toString(stringset) + "in line " + line);
                    }
                    ++i;
                }
                data.add(new DataTuple(line_number, set));
            }
            br.close();
        }
        catch (IOException e) {
            LOGGER.error("Exception!", e);
        }
        return data;
    }

    protected String getContentFromLine(String line) {
        return line.split("[\t ]", -1)[1];
    }

    protected String getSplitString() {
        return ",";
    }
}

