/*
 * Decompiled with CFR 0.152.
 */
package scj.evaluation;

import java.util.Set;
import scj.algorithm.ConfigurableRawDataAlgorithm;
import scj.algorithm.RawDataAlgorithm;
import scj.algorithm.order.SortOrder;
import scj.algorithm.pretti.Pretti;
import scj.algorithm.twotrees.labeling.DAAlgorithm;
import scj.algorithm.twotrees.labeling.sa.LabelingSA;
import scj.evaluation.Executor;
import scj.input.DataTuple;
import scj.result.CountResultList;
import scj.runtime.RuntimeCalculator;

public class BenchmarkExecutor
extends Executor {
    public BenchmarkExecutor(RawDataAlgorithm algorithm) {
        super(algorithm);
    }

    public static void main(String[] args) {
        Executor.MODE = BenchmarkExecutor.getExecutionMode(args);
        SortOrder order = BenchmarkExecutor.getSortOrder(args);
        ConfigurableRawDataAlgorithm alg = BenchmarkExecutor.getAlgorithm(args);
        if (alg instanceof DAAlgorithm) {
            ((DAAlgorithm)alg).setSortOrder(order);
        } else if (alg instanceof LabelingSA) {
            ((LabelingSA)alg).setSortOrder(order);
        } else if (alg instanceof Pretti) {
            ((Pretti)alg).setSortOrder(order);
        }
        BenchmarkExecutor exec = new BenchmarkExecutor(alg);
        CountResultList r = new CountResultList(alg.getClass().getName());
        Set<DataTuple>[] data = BenchmarkExecutor.getExample(args);
        exec.preexecute(data[0], data[1], r);
        RuntimeCalculator rc = new RuntimeCalculator(alg.getClass());
        rc.start("execute");
        exec.execute(data[0], data[1], r);
        rc.stop("execute");
        System.out.println(rc);
    }

    protected static Executor.EXECUTION_MODE getExecutionMode(String[] args) {
        String executionMode;
        boolean argsOffset = false;
        if (args.length == 0) {
            System.out.println("You have to specify an execution mode.");
            System.exit(1);
        }
        if ((executionMode = args[0]).equals("time")) {
            return Executor.EXECUTION_MODE.Time;
        }
        if (executionMode.equals("timebuildup")) {
            return Executor.EXECUTION_MODE.TimeBuildUp;
        }
        return Executor.EXECUTION_MODE.Space;
    }

    protected static SortOrder getSortOrder(String[] args) {
        boolean argsOffset = true;
        return BenchmarkExecutor.getSortOrderByOffset(args, 1);
    }

    private static ConfigurableRawDataAlgorithm getAlgorithm(String[] args) {
        int argsOffset = 2;
        if (args.length == 2) {
            System.out.println("You have to specify an algorithm.");
            System.exit(1);
        }
        String algorithmName = args[2];
        ConfigurableRawDataAlgorithm algorithm = BenchmarkExecutor.getAlgorithmByName(algorithmName);
        return algorithm;
    }

    protected static Set<DataTuple>[] getExample(String[] args) {
        int argsOffset = 3;
        return BenchmarkExecutor.getDataTuplesByOffset(args, 3);
    }
}

