/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.minmax.analysis;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class MinMaxSearchAnalysisTimeAtFirstLevels
implements Search {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinMaxSearchAnalysisTimeAtFirstLevels.class);
    public static final int LEVELS = 20;
    protected Result result;
    private FlatLeftTreeDirectBuildMinPathLength R;
    private PIETreeMaxPathLength S;
    public long[] runTime = new long[21];
    private long currentTime;

    public MinMaxSearchAnalysisTimeAtFirstLevels(FlatLeftTreeDirectBuildMinPathLength t1, PIETreeMaxPathLength t2, Result result) {
        this.R = t1;
        this.S = t2;
        this.result = result;
    }

    @Override
    public Result search() {
        int i = 0;
        while (i < 21) {
            this.runTime[i] = 0L;
            ++i;
        }
        this.currentTime = System.currentTimeMillis();
        this.search(0, 0, 0);
        LOGGER.info("Runtime on tree level or R: " + Arrays.toString(this.runTime));
        this.result.output();
        return this.result;
    }

    public String toString() {
        return this.R + "\n" + this.S;
    }

    protected long search(int r, int s, int level) {
        long start = System.currentTimeMillis();
        this.lookForOutput(r, s);
        Iterator iterator = this.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            int min_path = this.R.getMinPathLengthOf(c_r);
            IntList result = this.S.findRanges(this.R.getNameOf(c_r), s);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                int c_s = resultItr.nextInt();
                if (min_path > this.S.getMaxPathLengthOf(c_s)) continue;
                start += this.search(c_r, c_s, level + 1);
            }
        }
        long time = System.currentTimeMillis() - start;
        if (level > 0 && level <= 20) {
            int n = level - 1;
            this.runTime[n] = this.runTime[n] + time;
        } else if (level > 20) {
            this.runTime[20] = this.runTime[20] + time;
        }
        return time;
    }

    private void lookForOutput(int r, int s) {
        IntList content_r = this.R.getIdsByPosition(r);
        IntIterator it_r = content_r.iterator();
        if (it_r.hasNext()) {
            IntList result_s = this.S.getIdsByPosition(s, this.S.getRangeEnd(s) + 1);
            while (it_r.hasNext()) {
                int nextInt = it_r.nextInt();
                IntIterator it_s = result_s.iterator();
                while (it_s.hasNext()) {
                    this.result.add(nextInt, it_s.nextInt());
                }
            }
        }
    }
}

