/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.twotrees.labeling.minmax;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import scj.algorithm.tree.leftside.FlatLeftTreeDirectBuildMinPathLength;
import scj.algorithm.tree.rightside.PIETreeMaxPathLength;
import scj.algorithm.twotrees.Search;
import scj.result.Result;

public class MinMaxSearchListBasedRecursion
implements Search {
    protected Result result;
    private FlatLeftTreeDirectBuildMinPathLength R;
    private PIETreeMaxPathLength S;

    public MinMaxSearchListBasedRecursion(FlatLeftTreeDirectBuildMinPathLength t1, PIETreeMaxPathLength t2, Result result) {
        this.R = t1;
        this.S = t2;
        this.result = result;
    }

    @Override
    public Result search() {
        IntArrayList integers = new IntArrayList();
        integers.add(0);
        this.search(0, integers);
        return this.result;
    }

    public String toString() {
        return this.R + "\n" + this.S;
    }

    protected void search(int r, IntList s) {
        if (s.size() == 0) {
            return;
        }
        this.lookForOutput(r, s);
        Iterator iterator = this.R.getChildrenOf(r).iterator();
        while (iterator.hasNext()) {
            int c_r = (Integer)iterator.next();
            int min_path = this.R.getMinPathLengthOf(c_r);
            IntList allRanges = this.S.findAllRanges(this.R.getNameOf(c_r), s);
            IntArrayList result = new IntArrayList(allRanges);
            IntListIterator resultItr = result.iterator();
            while (resultItr.hasNext()) {
                int c_s = resultItr.nextInt();
                if (min_path <= this.S.getMaxPathLengthOf(c_s)) continue;
                resultItr.remove();
            }
            this.search(c_r, result);
        }
    }

    private void lookForOutput(int r, IntList s) {
        IntList content_r = this.R.getIdsByPosition(r);
        if (content_r.isEmpty()) {
            return;
        }
        IntListIterator it_preorder_s = s.iterator();
        while (it_preorder_s.hasNext()) {
            int preorder_s = it_preorder_s.nextInt();
            IntList content_s = this.S.getIdsByPosition(preorder_s, this.S.getRangeEnd(preorder_s) + 1);
            IntIterator it_content_r = content_r.iterator();
            while (it_content_r.hasNext()) {
                int tupleId_r = it_content_r.nextInt();
                IntListIterator it_content_s = content_s.iterator();
                while (it_content_s.hasNext()) {
                    this.result.add(tupleId_r, it_content_s.nextInt());
                }
            }
        }
    }
}

