/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.order;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scj.algorithm.order.SortOrder;
import scj.algorithm.order.comparator.FrequencyMapAscendingOrderComparator;
import scj.algorithm.order.comparator.FrequencyMapComparator;
import scj.algorithm.order.comparator.NodeNameComparator;
import scj.algorithm.tree.Node;
import scj.input.DataTuple;

public class FrequencyOrder
implements SortOrder {
    private FrequencyMapComparator bvc;
    protected Map<Integer, Integer> frequencyMap;

    @Override
    public void initialize(Set<DataTuple> set) {
        this.frequencyMap = this.getFrequencyMap(set);
        this.bvc = this.getComparatorByFrequencyMap(this.frequencyMap);
    }

    protected FrequencyMapComparator getComparatorByFrequencyMap(Map<Integer, Integer> frequencyMap) {
        return new FrequencyMapAscendingOrderComparator(frequencyMap);
    }

    @Override
    public int[] sort(int[] set) {
        List<Integer> asList = Ints.asList(set);
        Collections.sort(asList, this.bvc);
        return Ints.toArray(asList);
    }

    protected Map<Integer, Integer> getFrequencyMap(Set<DataTuple> set1) {
        Int2IntOpenHashMap alphabet = new Int2IntOpenHashMap(set1.size());
        for (DataTuple r : set1) {
            int[] nArray = r.getSet();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int entry = nArray[n2];
                if (alphabet.containsKey((Object)entry)) {
                    alphabet.put(Integer.valueOf(entry), Integer.valueOf((Integer)alphabet.get((Object)entry) + 1));
                } else {
                    alphabet.put(Integer.valueOf(entry), Integer.valueOf(1));
                }
                ++n2;
            }
        }
        return alphabet;
    }

    @Override
    public List<Node> sort(Collection<Node> child) {
        ArrayList<Node> list = new ArrayList<Node>(child);
        Collections.sort(list, new NodeNameComparator(this.bvc));
        return list;
    }

    @Override
    public Map<Integer, Integer> getFrequencyMap() {
        return this.frequencyMap;
    }

    public String toString() {
        return "FrequencyOrder";
    }
}

