/*
 * Decompiled with CFR 0.152.
 */
package scj.algorithm.limitremade.structures;

import gnu.trove.list.array.TIntArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import scj.input.DataTuple;

public class LIMITOPJInvertedIndex {
    private static final TIntArrayList EMPTY_LIST = new TIntArrayList();
    protected Map<Integer, TIntArrayList> index = new Int2ObjectOpenHashMap<TIntArrayList>();
    protected long tupleCount = 0L;

    public LIMITOPJInvertedIndex() {
    }

    public LIMITOPJInvertedIndex(Set<DataTuple> set2) {
        this.fillIndex(set2);
    }

    public LIMITOPJInvertedIndex(int[][] set2) {
        this.fillIndex(set2);
    }

    public void fillIndex(Set<DataTuple> set2) {
        this.tupleCount += (long)set2.size();
        for (DataTuple tuple : set2) {
            int[] nArray = tuple.getSet();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int name = nArray[n2];
                if (!this.index.containsKey(name)) {
                    this.index.put(name, new TIntArrayList());
                }
                this.index.get(name).add(tuple.getId());
                ++n2;
            }
        }
        for (TIntArrayList tupleIdList : this.index.values()) {
            tupleIdList.sort();
        }
    }

    public void fillIndex(int[][] set2) {
        this.fillIndex(set2, 1, set2.length);
    }

    public void fillIndex(int[][] set2, int begin, int end) {
        int tCnt = end - begin;
        this.tupleCount += (long)tCnt;
        int i = begin;
        while (i < end) {
            int j = 0;
            while (j < set2[i].length) {
                int name = set2[i][j];
                if (!this.index.containsKey(name)) {
                    this.index.put(name, new TIntArrayList());
                }
                this.index.get(name).add(i);
                ++j;
            }
            ++i;
        }
    }

    public int getSize() {
        return this.index.keySet().size();
    }

    public long getTupleCount() {
        return this.tupleCount;
    }

    public TIntArrayList get(int i) {
        if (this.index.containsKey(i)) {
            return this.index.get(i);
        }
        return EMPTY_LIST;
    }

    public String toString() {
        return "Inverted index: " + this.index.toString();
    }
}

