/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util.tq;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.teatrove.trove.util.NoThreadException;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.ThreadPool;
import org.teatrove.trove.util.tq.Transaction;
import org.teatrove.trove.util.tq.TransactionQueueData;
import org.teatrove.trove.util.tq.TransactionQueueEvent;
import org.teatrove.trove.util.tq.TransactionQueueListener;
import org.teatrove.trove.util.tq.TransactionQueueSizeTuner;
import org.teatrove.trove.util.tq.TransactionQueueThreadTuner;
import org.teatrove.trove.util.tq.UncaughtExceptionEvent;
import org.teatrove.trove.util.tq.UncaughtExceptionListener;

public class TransactionQueue {
    private ThreadPool mThreadPool;
    private String mName;
    private int mMaxSize;
    private int mMaxThreads;
    private long mIdleTimeout;
    private long mTransactionTimeout;
    private LinkedList mQueue = new LinkedList();
    private int mThreadCount;
    private int mServicingCount;
    private int mThreadId;
    private boolean mSuspended;
    private Worker mWorker = new Worker();
    private Collection mListeners = new LinkedList();
    private Collection mExceptionListeners = new LinkedList();
    private long mTimeLapseStart;
    private int mPeakQueueSize;
    private int mPeakThreadCount;
    private int mPeakServicingCount;
    private int mTotalEnqueueAttempts;
    private int mTotalEnqueued;
    private int mTotalServiced;
    private int mTotalExpired;
    private int mTotalServiceExceptions;
    private int mTotalUncaughtExceptions;
    private long mTotalQueueDuration;
    private long mTotalServiceDuration;

    public TransactionQueue(ThreadPool tp, int maxSize, int maxThreads) {
        this(tp, "TransactionQueue", maxSize, maxThreads);
    }

    public TransactionQueue(ThreadPool tp, String name, int maxSize, int maxThreads) {
        this.mThreadPool = tp;
        this.mName = name;
        this.setMaximumSize(maxSize);
        this.setMaximumThreads(maxThreads);
        this.setIdleTimeout(tp.getIdleTimeout());
        this.setTransactionTimeout(-1L);
        this.resetStatistics();
    }

    public synchronized void setIdleTimeout(long timeout) {
        this.mIdleTimeout = timeout;
    }

    public synchronized long getIdleTimeout() {
        return this.mIdleTimeout;
    }

    public synchronized void setTransactionTimeout(long timeout) {
        this.mTransactionTimeout = timeout;
    }

    public synchronized long getTransactionTimeout() {
        return this.mTransactionTimeout;
    }

    public String getName() {
        return this.mName;
    }

    public synchronized int getMaximumSize() {
        return this.mMaxSize;
    }

    public synchronized void setMaximumSize(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("TransactionQueue max size must be positive: " + max);
        }
        this.mMaxSize = max;
    }

    public synchronized int getMaximumThreads() {
        return this.mMaxThreads;
    }

    public synchronized void setMaximumThreads(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("TransactionQueue must have at least one thread: " + max);
        }
        this.mMaxThreads = max;
    }

    public synchronized boolean enqueue(Transaction transaction) {
        ++this.mTotalEnqueueAttempts;
        if (transaction == null || this.mThreadPool.isClosed()) {
            return false;
        }
        int queueSize = this.mQueue.size();
        if (queueSize >= this.mMaxSize) {
            if (this.mListeners.size() > 0) {
                TransactionQueueEvent event = new TransactionQueueEvent(this, transaction);
                Iterator it = this.mListeners.iterator();
                while (it.hasNext()) {
                    ((TransactionQueueListener)it.next()).transactionQueueFull(event);
                }
            }
            return false;
        }
        if (!this.mSuspended && !this.ensureWaitingThread()) {
            return false;
        }
        ++this.mTotalEnqueued;
        TransactionQueueEvent event = new TransactionQueueEvent(this, transaction);
        this.mQueue.addLast(event);
        if (++queueSize > this.mPeakQueueSize) {
            this.mPeakQueueSize = queueSize;
        }
        this.notify();
        if (this.mListeners.size() > 0) {
            Iterator it = this.mListeners.iterator();
            while (it.hasNext()) {
                ((TransactionQueueListener)it.next()).transactionEnqueued(event);
            }
        }
        return true;
    }

    public synchronized void suspend() {
        if (!this.mSuspended) {
            this.mQueue.addFirst(null);
            this.notify();
            this.mSuspended = true;
        }
    }

    public synchronized boolean resume() {
        if (this.mSuspended) {
            this.mSuspended = false;
        }
        return this.ensureWaitingThread();
    }

    public synchronized void idle() {
        this.mQueue.addLast(null);
        this.notify();
    }

    public synchronized void addTransactionQueueListener(TransactionQueueListener listener) {
        this.mListeners.add(listener);
    }

    public synchronized void removeTransactionQueueListener(TransactionQueueListener listener) {
        this.mListeners.remove(listener);
    }

    public synchronized void addUncaughtExceptionListener(UncaughtExceptionListener listener) {
        this.mExceptionListeners.add(listener);
    }

    public synchronized void removeUncaughtExceptionListener(UncaughtExceptionListener listener) {
        this.mExceptionListeners.remove(listener);
    }

    public synchronized int getQueueSize() {
        return this.mQueue.size();
    }

    public synchronized int getThreadCount() {
        return this.mThreadCount;
    }

    public synchronized TransactionQueueData getStatistics() {
        return new TransactionQueueData(this, this.mTimeLapseStart, System.currentTimeMillis(), this.mQueue.size(), this.mThreadCount, this.mServicingCount, this.mPeakQueueSize, this.mPeakThreadCount, this.mPeakServicingCount, this.mTotalEnqueueAttempts, this.mTotalEnqueued, this.mTotalServiced, this.mTotalExpired, this.mTotalServiceExceptions, this.mTotalUncaughtExceptions, this.mTotalQueueDuration, this.mTotalServiceDuration);
    }

    public synchronized void resetStatistics() {
        this.mPeakQueueSize = 0;
        this.mPeakThreadCount = 0;
        this.mPeakServicingCount = 0;
        this.mTotalEnqueueAttempts = 0;
        this.mTotalEnqueued = 0;
        this.mTotalServiced = 0;
        this.mTotalExpired = 0;
        this.mTotalServiceExceptions = 0;
        this.mTotalUncaughtExceptions = 0;
        this.mTotalQueueDuration = 0L;
        this.mTotalServiceDuration = 0L;
        this.mTimeLapseStart = System.currentTimeMillis();
    }

    public synchronized void applyProperties(PropertyMap properties) {
        if (properties.containsKey("max.size")) {
            this.setMaximumSize(properties.getInt("max.size"));
        }
        if (properties.containsKey("max.threads")) {
            this.setMaximumThreads(properties.getInt("max.threads"));
        }
        if (properties.containsKey("timeout.idle")) {
            this.setIdleTimeout(properties.getNumber("timeout.idle").longValue());
        }
        if (properties.containsKey("timeout.transaction")) {
            this.setTransactionTimeout(properties.getNumber("timeout.transaction").longValue());
        }
        if ("true".equalsIgnoreCase(properties.getString("tune.size"))) {
            this.addTransactionQueueListener(new TransactionQueueSizeTuner());
        }
        if ("true".equalsIgnoreCase(properties.getString("tune.threads"))) {
            this.addTransactionQueueListener(new TransactionQueueThreadTuner());
        }
    }

    synchronized void startThread(boolean canwait) throws InterruptedException {
        if (this.mThreadCount < this.mMaxThreads) {
            String threadName = this.getName() + ' ' + this.mThreadId++;
            if (canwait) {
                this.mThreadPool.start((Runnable)this.mWorker, threadName);
            } else {
                this.mThreadPool.start(this.mWorker, 0L, threadName);
            }
            if (++this.mThreadCount > this.mPeakThreadCount) {
                this.mPeakThreadCount = this.mThreadCount;
            }
        }
    }

    synchronized TransactionQueueEvent nextTransactionEvent() throws InterruptedException {
        if (this.mQueue.isEmpty() && this.mIdleTimeout != 0L) {
            if (this.mIdleTimeout < 0L) {
                this.wait();
            } else {
                this.wait(this.mIdleTimeout);
            }
        }
        if (this.mQueue.isEmpty()) {
            return null;
        }
        return (TransactionQueueEvent)this.mQueue.removeFirst();
    }

    synchronized TransactionQueueEvent transactionDequeued(TransactionQueueEvent event) {
        if (++this.mServicingCount > this.mPeakServicingCount) {
            this.mPeakServicingCount = this.mServicingCount;
        }
        TransactionQueueEvent deqEvent = new TransactionQueueEvent(event);
        this.mTotalQueueDuration += deqEvent.getTimestampMillis() - event.getTimestampMillis();
        if (this.mListeners.size() > 0) {
            Iterator it = this.mListeners.iterator();
            while (it.hasNext()) {
                ((TransactionQueueListener)it.next()).transactionDequeued(deqEvent);
            }
        }
        return deqEvent;
    }

    synchronized void transactionServiced(TransactionQueueEvent event) {
        TransactionQueueEvent svcEvent = new TransactionQueueEvent(event);
        this.mTotalServiceDuration += svcEvent.getTimestampMillis() - event.getTimestampMillis();
        if (this.mListeners.size() > 0) {
            Iterator it = this.mListeners.iterator();
            while (it.hasNext()) {
                ((TransactionQueueListener)it.next()).transactionServiced(svcEvent);
            }
        }
        --this.mServicingCount;
        ++this.mTotalServiced;
    }

    synchronized void transactionExpired(TransactionQueueEvent event) {
        --this.mServicingCount;
        ++this.mTotalExpired;
        if (this.mListeners.size() > 0) {
            event = new TransactionQueueEvent(event);
            Iterator it = this.mListeners.iterator();
            while (it.hasNext()) {
                ((TransactionQueueListener)it.next()).transactionExpired(event);
            }
        }
    }

    synchronized void transactionException(TransactionQueueEvent event, Throwable e) {
        --this.mServicingCount;
        ++this.mTotalServiceExceptions;
        if (this.mListeners.size() > 0) {
            event = new TransactionQueueEvent(event, e);
            Iterator it = this.mListeners.iterator();
            while (it.hasNext()) {
                ((TransactionQueueListener)it.next()).transactionException(event);
            }
        }
    }

    synchronized void uncaughtException(Throwable e) {
        ++this.mTotalUncaughtExceptions;
        if (this.mExceptionListeners.size() > 0) {
            UncaughtExceptionEvent event = new UncaughtExceptionEvent(this, e);
            Iterator it = this.mExceptionListeners.iterator();
            while (it.hasNext()) {
                ((UncaughtExceptionListener)it.next()).uncaughtException(event);
            }
        } else {
            Thread current = Thread.currentThread();
            current.getThreadGroup().uncaughtException(current, e);
        }
    }

    synchronized boolean exitThread(boolean force) {
        if (!force && this.mThreadCount - this.mServicingCount <= 1 && this.mQueue.size() > 0 && !this.mSuspended) {
            return false;
        }
        --this.mThreadCount;
        return true;
    }

    private synchronized boolean ensureWaitingThread() {
        if (this.mThreadCount <= this.mServicingCount) {
            try {
                this.startThread(this.mThreadCount == 0);
            }
            catch (NoThreadException e) {
                if (!e.isThreadPoolClosed() && this.mThreadCount == 0) {
                    this.uncaughtException(e);
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (Throwable e) {
                this.uncaughtException(e);
                return false;
            }
        }
        return true;
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean forceExit = false;
            while (true) {
                try {
                    TransactionQueueEvent event = null;
                    try {
                        event = TransactionQueue.this.nextTransactionEvent();
                        if (event == null) continue;
                    }
                    catch (InterruptedException e) {
                        forceExit = true;
                    }
                    long enqueueTimestamp = event.getTimestampMillis();
                    try {
                        TransactionQueue.this.startThread(false);
                    }
                    catch (NoThreadException e) {
                        if (e.isThreadPoolClosed()) {
                            forceExit = true;
                        }
                    }
                    catch (InterruptedException e) {
                        forceExit = true;
                    }
                    catch (Throwable e) {
                        TransactionQueue.this.uncaughtException(e);
                    }
                    finally {
                        try {
                            event = TransactionQueue.this.transactionDequeued(event);
                        }
                        catch (Throwable e) {
                            TransactionQueue.this.uncaughtException(e);
                        }
                    }
                    long serviceTimestamp = event.getTimestampMillis();
                    long timeout = TransactionQueue.this.getTransactionTimeout();
                    if (timeout >= 0L && serviceTimestamp - enqueueTimestamp >= timeout) {
                        try {
                            event.getTransaction().cancel();
                            continue;
                        }
                        finally {
                            TransactionQueue.this.transactionExpired(event);
                            continue;
                        }
                    }
                    try {
                        event.getTransaction().service();
                        TransactionQueue.this.transactionServiced(event);
                    }
                    catch (Throwable e) {
                        TransactionQueue.this.uncaughtException(e);
                        try {
                            event.getTransaction().cancel();
                        }
                        catch (Throwable e2) {
                            TransactionQueue.this.uncaughtException(e2);
                        }
                        TransactionQueue.this.transactionException(event, e);
                    }
                    continue;
                }
                catch (Throwable e) {
                    try {
                        TransactionQueue.this.uncaughtException(e);
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                finally {
                    if (TransactionQueue.this.exitThread(forceExit)) break;
                    continue;
                }
                break;
            }
        }
    }
}

