/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashSet
extends AbstractSet
implements Set,
Cloneable {
    private static final Null NULL = new Null();
    private transient Entry[] mTable;
    private transient int mCount;
    private int mThreshold;
    private float mLoadFactor;
    private transient int mModCount = 0;

    public WeakHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.mLoadFactor = loadFactor;
        this.mTable = new Entry[initialCapacity];
        this.mThreshold = (int)((float)initialCapacity * loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashSet() {
        this(11, 0.75f);
    }

    public WeakHashSet(Collection c) {
        this(Math.max(2 * c.size(), 11), 0.75f);
        this.addAll(c);
    }

    @Override
    public Iterator iterator() {
        return new SetIterator();
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean isEmpty() {
        return this.mCount == 0;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            obj = NULL;
        }
        Entry[] tab = this.mTable;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return true;
                }
                prev = e;
            }
            e = e.mNext;
        }
        return false;
    }

    private void cleanup() {
        Entry[] tab = this.mTable;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[i] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    prev = e;
                }
                e = e.mNext;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.mTable.length;
        Entry[] oldSet = this.mTable;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newSet = new Entry[newCapacity];
        ++this.mModCount;
        this.mThreshold = (int)((float)newCapacity * this.mLoadFactor);
        this.mTable = newSet;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldSet[i];
            while (old != null) {
                Entry e = old;
                old = old.mNext;
                if (e.get() == null) {
                    --this.mCount;
                    continue;
                }
                int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                e.mNext = newSet[index];
                newSet[index] = e;
            }
        }
    }

    @Override
    public boolean add(Object obj) {
        if (obj == null) {
            obj = NULL;
        }
        Entry[] tab = this.mTable;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return false;
                }
                prev = e;
            }
            e = e.mNext;
        }
        if (this.mCount >= this.mThreshold) {
            this.cleanup();
        }
        if (this.mCount >= this.mThreshold) {
            this.rehash();
            tab = this.mTable;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(obj == NULL ? new Null() : obj, hash, tab[index]);
        ++this.mCount;
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        Entry[] tab = this.mTable;
        if (obj == null) {
            obj = NULL;
        }
        int hash = obj.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object entryValue = e.get();
            if (entryValue == null) {
                ++this.mModCount;
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash) {
                    ++this.mModCount;
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[index] = e.mNext;
                    }
                    --this.mCount;
                    return true;
                }
                prev = e;
            }
            e = e.mNext;
        }
        return false;
    }

    @Override
    public void clear() {
        Entry[] tab = this.mTable;
        ++this.mModCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.mCount = 0;
    }

    public Object clone() {
        try {
            WeakHashSet t = (WeakHashSet)super.clone();
            t.mTable = new Entry[this.mTable.length];
            int i = this.mTable.length;
            while (i-- > 0) {
                t.mTable[i] = this.mTable[i] != null ? (Entry)this.mTable[i].clone() : null;
            }
            t.mModCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        buf.append("[");
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(it.next()));
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    protected int hashCode(Object obj) {
        return obj.hashCode();
    }

    protected boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    static class Null {
        Null() {
        }

        public boolean equals(Object other) {
            return other == null || other instanceof Null;
        }

        public String toString() {
            return "null";
        }
    }

    private class SetIterator
    implements Iterator {
        private Entry[] mTable;
        private int mIndex;
        private Entry mEntry;
        private Object mEntryValue;
        private Entry mLastReturned;
        private int expectedModCount;

        private SetIterator() {
            this.mTable = WeakHashSet.this.mTable;
            this.mIndex = this.mTable.length;
            this.expectedModCount = WeakHashSet.this.mModCount;
        }

        @Override
        public boolean hasNext() {
            while (this.mEntry == null || (this.mEntryValue = this.mEntry.get()) == null) {
                if (this.mEntry != null) {
                    this.mEntry = this.mEntry.mNext;
                    continue;
                }
                if (this.mIndex <= 0) {
                    return false;
                }
                this.mEntry = this.mTable[--this.mIndex];
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mLastReturned = this.mEntry;
            this.mEntry = this.mEntry.mNext;
            return this.mEntryValue;
        }

        @Override
        public void remove() {
            if (this.mLastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashSet.this.mModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.remove(this.mLastReturned);
            this.mLastReturned = null;
        }

        private void remove(Entry toRemove) {
            Entry[] tab = this.mTable;
            int index = (toRemove.mHash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == toRemove) {
                    WeakHashSet.this.mModCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    WeakHashSet.this.mCount--;
                    return;
                }
                prev = e;
                e = e.mNext;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    extends WeakReference {
        int mHash;
        Entry mNext;

        Entry(Object obj, int hash, Entry next) {
            super(obj);
            this.mHash = hash;
            this.mNext = next;
        }

        @Override
        protected Object clone() {
            return new Entry(this.get(), this.mHash, this.mNext == null ? null : (Entry)this.mNext.clone());
        }
    }
}

