/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.IOException;
import org.teatrove.trove.util.PropertyChangeListener;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyMapFactory;
import org.teatrove.trove.util.SubstitutionFactory;

public class SubstitutionPropertyMapFactory
implements PropertyMapFactory {
    private PropertyMap substitutions;
    private PropertyMapFactory factory;

    public SubstitutionPropertyMapFactory(PropertyMapFactory factory) {
        this.factory = factory;
    }

    public SubstitutionPropertyMapFactory(PropertyMapFactory factory, PropertyMap substitutions) {
        this.factory = factory;
        this.substitutions = substitutions;
    }

    @Override
    public PropertyMap createProperties() throws IOException {
        return this.createProperties(null);
    }

    @Override
    public PropertyMap createProperties(PropertyChangeListener listener) throws IOException {
        PropertyMap props = this.factory.createProperties(listener);
        this.substitute(props);
        return props;
    }

    protected void substitute(PropertyMap props) {
        Object[] keys;
        for (Object key : keys = props.keySet().toArray(new Object[props.size()])) {
            Object value = props.get(key);
            if (value == null) continue;
            value = SubstitutionFactory.substitute(value.toString(), this.substitutions);
            props.put(key, value);
        }
    }
}

