/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.Iterator;
import java.util.Map;

public class StringReplacer {
    private StringReplacer() {
    }

    public static String replace(String source, String pattern, String replacement) {
        return StringReplacer.replace(source, pattern, replacement, 0);
    }

    public static String replace(String source, String pattern, String replacement, int fromIndex) {
        StringBuffer buf;
        int patternLength;
        if (source == null) {
            if (pattern == null) {
                return replacement;
            }
            return source;
        }
        if (pattern == null || (patternLength = pattern.length()) == 0) {
            return source;
        }
        int sourceLength = source.length();
        if (fromIndex <= 0) {
            fromIndex = 0;
            buf = new StringBuffer(sourceLength);
        } else if (fromIndex < sourceLength) {
            buf = new StringBuffer(sourceLength);
            buf.append(source.substring(0, fromIndex));
        } else {
            return source;
        }
        int s = fromIndex;
        block0: while (s < sourceLength) {
            int k = s;
            int j = 0;
            while (j < patternLength) {
                if (k >= sourceLength || source.charAt(k) != pattern.charAt(j)) {
                    buf.append(source.charAt(s));
                    ++s;
                    continue block0;
                }
                ++j;
                ++k;
            }
            buf.append(replacement);
            s = k;
        }
        return buf.toString();
    }

    public static String replace(String source, Map patternReplacements) {
        if (source == null) {
            return null;
        }
        int mapSize = patternReplacements.size();
        String[] patterns = new String[mapSize];
        String[] replacements = new String[mapSize];
        Iterator it = patternReplacements.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            patterns[i] = (String)entry.getKey();
            replacements[i] = (String)entry.getValue();
            ++i;
        }
        return StringReplacer.replace(source, patterns, replacements);
    }

    public static String replace(String source, String[] patterns, String[] replacements) {
        int patternsLength = patterns.length;
        int sourceLength = source.length();
        StringBuffer buf = new StringBuffer(sourceLength);
        int s = 0;
        while (s < sourceLength) {
            int longestPattern = 0;
            int closestPattern = -1;
            block1: for (int i = 0; i < patternsLength; ++i) {
                String pattern = patterns[i];
                int patternLength = pattern.length();
                if (patternLength <= 0) continue;
                int j = 0;
                int k = s;
                while (j < patternLength) {
                    if (k >= sourceLength || source.charAt(k) != pattern.charAt(j)) continue block1;
                    ++j;
                    ++k;
                }
                if (patternLength <= longestPattern) continue;
                longestPattern = patternLength;
                closestPattern = i;
            }
            if (closestPattern >= 0) {
                buf.append(replacements[closestPattern]);
                s += longestPattern;
                continue;
            }
            buf.append(source.charAt(s));
            ++s;
        }
        return buf.toString();
    }

    public static String replaceFirst(String source, String pattern, String replacement) {
        return StringReplacer.replaceOne(source, pattern, replacement, StringReplacer.findFirst(source, pattern));
    }

    public static String replaceFirst(String source, String pattern, String replacement, int fromIndex) {
        return StringReplacer.replaceOne(source, pattern, replacement, StringReplacer.findFirst(source, pattern, fromIndex));
    }

    public static String replaceLast(String source, String pattern, String replacement) {
        return StringReplacer.replaceOne(source, pattern, replacement, StringReplacer.findLast(source, pattern));
    }

    public static String replaceLast(String source, String pattern, String replacement, int fromIndex) {
        return StringReplacer.replaceOne(source, pattern, replacement, StringReplacer.findLast(source, pattern, fromIndex));
    }

    private static String replaceOne(String source, String pattern, String replacement, int atIndex) {
        if (atIndex < 0) {
            if (source == null && pattern == null) {
                return replacement;
            }
            return source;
        }
        StringBuffer buf = new StringBuffer(source.length() - pattern.length() + replacement.length());
        buf.append(source.substring(0, atIndex));
        buf.append(replacement);
        buf.append(source.substring(atIndex + pattern.length()));
        return buf.toString();
    }

    private static int findFirst(String str, String search) {
        return str == null || search == null ? -1 : str.indexOf(search);
    }

    private static int findFirst(String str, String search, int fromIndex) {
        return str == null || search == null ? -1 : str.indexOf(search, fromIndex);
    }

    private static int findLast(String str, String search) {
        return str == null || search == null ? -1 : str.lastIndexOf(search);
    }

    private static int findLast(String str, String search, int fromIndex) {
        return str == null || search == null ? -1 : str.lastIndexOf(search, fromIndex);
    }
}

