/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teatrove.trove.util.IdentityMap;

public class FlyweightSet
extends AbstractSet {
    private Entry[] mTable;
    private int mCount;
    private int mThreshold;
    private float mLoadFactor;

    public FlyweightSet() {
        int initialCapacity = 101;
        float loadFactor = 0.75f;
        this.mLoadFactor = 0.75f;
        this.mTable = new Entry[101];
        this.mThreshold = 75;
    }

    public synchronized Object put(Object obj) {
        if (obj == null) {
            return null;
        }
        Entry[] tab = this.mTable;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return iobj;
                }
                prev = e;
            }
            e = e.mNext;
        }
        if (this.mCount >= this.mThreshold) {
            this.cleanup();
        }
        if (this.mCount >= this.mThreshold) {
            this.rehash();
            tab = this.mTable;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(obj, hash, tab[index]);
        ++this.mCount;
        return obj;
    }

    @Override
    public Iterator iterator() {
        return new SetIterator();
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        Entry[] tab = this.mTable;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev != null) {
                    prev.mNext = e.mNext;
                } else {
                    tab[index] = e.mNext;
                }
                --this.mCount;
            } else {
                if (e.mHash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return true;
                }
                prev = e;
            }
            e = e.mNext;
        }
        return false;
    }

    @Override
    public String toString() {
        return IdentityMap.toString(this);
    }

    protected int hashCode(Object obj) {
        return obj.hashCode();
    }

    protected boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    private void cleanup() {
        Entry[] tab = this.mTable;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                if (e.get() == null) {
                    if (prev != null) {
                        prev.mNext = e.mNext;
                    } else {
                        tab[i] = e.mNext;
                    }
                    --this.mCount;
                } else {
                    prev = e;
                }
                e = e.mNext;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.mTable.length;
        Entry[] tab = this.mTable;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTab = new Entry[newCapacity];
        this.mThreshold = (int)((float)newCapacity * this.mLoadFactor);
        this.mTable = newTab;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = tab[i];
            while (old != null) {
                Entry e = old;
                old = old.mNext;
                if (e.get() == null) {
                    --this.mCount;
                    continue;
                }
                int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                e.mNext = newTab[index];
                newTab[index] = e;
            }
        }
    }

    private class SetIterator
    implements Iterator {
        private Entry[] mTable;
        private int mIndex;
        private Entry mEntry;
        private Object mEntryFlyweight;

        private SetIterator() {
            this.mTable = FlyweightSet.this.mTable;
            this.mIndex = this.mTable.length;
        }

        @Override
        public boolean hasNext() {
            while (this.mEntry == null || (this.mEntryFlyweight = this.mEntry.get()) == null) {
                if (this.mEntry != null) {
                    this.mEntry = this.mEntry.mNext;
                    continue;
                }
                if (this.mIndex <= 0) {
                    return false;
                }
                this.mEntry = this.mTable[--this.mIndex];
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mEntry = this.mEntry.mNext;
            return this.mEntryFlyweight;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Entry
    extends WeakReference {
        int mHash;
        Entry mNext;

        Entry(Object flyweight, int hash, Entry next) {
            super(flyweight);
            this.mHash = hash;
            this.mNext = next;
        }
    }
}

