/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FilteredMap<K, V>
implements Map<K, V> {
    private Map<K, V> mBackingMap = null;
    private Filter mFilter = null;

    public FilteredMap(Map<K, V> backingMap, Filter filter) {
        this.mBackingMap = backingMap;
        this.mFilter = filter;
        if (this.mBackingMap == null) {
            throw new IllegalArgumentException("Backing map must not be null");
        }
        if (this.mFilter == null) {
            throw new IllegalArgumentException("Filter instance must not be null");
        }
    }

    public FilteredMap(Map<K, V> backingMap) {
        this(backingMap, new Filter(){

            @Override
            public boolean accept(Map.Entry e) {
                return true;
            }
        });
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> s = new HashSet<Map.Entry<K, V>>(this.mBackingMap.size());
        for (Map.Entry<K, V> e : this.mBackingMap.entrySet()) {
            if (!this.mFilter.accept(e)) continue;
            s.add(e);
        }
        return s;
    }

    @Override
    public Collection<V> values() {
        Set<Map.Entry<K, V>> s = this.entrySet();
        ArrayList<V> l = new ArrayList<V>(s.size());
        for (Map.Entry<K, V> e : s) {
            l.add(e.getValue());
        }
        return l;
    }

    @Override
    public Set<K> keySet() {
        Set<Map.Entry<K, V>> s = this.entrySet();
        HashSet<K> keys = new HashSet<K>(s.size());
        for (Map.Entry<K, V> e : this.mBackingMap.entrySet()) {
            keys.add(e.getKey());
        }
        return keys;
    }

    @Override
    public void clear() {
        this.mBackingMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mBackingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mBackingMap.containsValue(value);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.mBackingMap).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.mBackingMap).hashCode();
    }

    @Override
    public V get(Object key) {
        return this.mBackingMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mBackingMap.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        return this.mBackingMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.mBackingMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.mBackingMap.remove(key);
    }

    @Override
    public int size() {
        return this.mBackingMap.size();
    }

    public static interface Filter {
        public boolean accept(Map.Entry var1);
    }
}

