/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

public class Deflater {
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    private static final int NO_FLUSH = 0;
    private static final int SYNC_FLUSH = 2;
    private static final int FULL_FLUSH = 3;
    private static final int FINISH = 4;
    private long mStream;
    private boolean mNoWrap;
    private int mStrategy;
    private int mLevel;
    private boolean mSetParams;
    private int mFlushOption = 0;
    private boolean mFinished;
    private byte[] mInputBuf;
    private int mInputOffset;
    private int mInputLength;

    public Deflater(int level, boolean nowrap) {
        this.mStream = this.init(0, level, nowrap);
        this.mStrategy = 0;
        this.mLevel = level;
        this.mNoWrap = nowrap;
    }

    public Deflater(int level) {
        this(level, false);
    }

    public Deflater() {
        this(-1, false);
    }

    public boolean isNoWrap() {
        return this.mNoWrap;
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        this.boundsCheck(b, off, len);
        this.mInputLength = len;
        this.mInputOffset = off;
        this.mInputBuf = b;
    }

    public synchronized void setInput(byte[] b) {
        this.mInputLength = b.length;
        this.mInputOffset = 0;
        this.mInputBuf = b;
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
        this.boundsCheck(b, off, len);
        this.setDictionary(this.mStream, b, off, len);
    }

    public synchronized void setDictionary(byte[] b) {
        this.setDictionary(this.mStream, b, 0, b.length);
    }

    public synchronized void setStrategy(int strategy) {
        this.mStrategy = strategy;
        this.mSetParams = true;
    }

    public synchronized void setLevel(int level) {
        this.mLevel = level;
        this.mSetParams = true;
    }

    public boolean needsInput() {
        return this.mInputLength <= 0;
    }

    public void flush() {
        this.mFlushOption = 2;
    }

    public void fullFlush() {
        this.mFlushOption = 3;
    }

    public void finish() {
        this.mFlushOption = 4;
    }

    public synchronized boolean finished() {
        return this.mFinished;
    }

    public int deflate(byte[] b, int off, int len) {
        this.boundsCheck(b, off, len);
        return this.deflate0(b, off, len);
    }

    public int deflate(byte[] b) {
        return this.deflate0(b, 0, b.length);
    }

    private synchronized int deflate0(byte[] b, int off, int len) {
        int amt = this.deflate(this.mStream, this.mFlushOption, this.mSetParams, this.mInputBuf, this.mInputOffset, this.mInputLength, b, off, len);
        if (amt < len && (this.mFlushOption == 2 || this.mFlushOption == 3)) {
            this.mFlushOption = 0;
        }
        return amt;
    }

    public synchronized int getAdler() {
        return this.getAdler(this.mStream);
    }

    public synchronized int getTotalIn() {
        return this.getTotalIn(this.mStream);
    }

    public synchronized int getTotalOut() {
        return this.getTotalOut(this.mStream);
    }

    public synchronized void reset() {
        this.mFinished = false;
        this.mFlushOption = 0;
        this.mInputBuf = null;
        this.mInputLength = 0;
        this.reset(this.mStream);
    }

    public synchronized void end() {
        this.end(this.mStream);
    }

    protected void finalize() {
        this.end();
    }

    private void boundsCheck(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static native void initIDs();

    private native long init(int var1, int var2, boolean var3);

    private native void setDictionary(long var1, byte[] var3, int var4, int var5);

    private native int deflate(long var1, int var3, boolean var4, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10);

    private native int getAdler(long var1);

    private native int getTotalIn(long var1);

    private native int getTotalOut(long var1);

    private native void reset(long var1);

    private native void end(long var1);

    static {
        System.loadLibrary("org.teatrove_trove_util_Deflater");
        Deflater.initIDs();
    }
}

