/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import org.teatrove.trove.util.SoftHashMap;
import org.teatrove.trove.util.UsageMap;

public class Cache
extends SoftHashMap {
    private final int mMaxRecent;
    private final UsageMap mUsageMap;

    public Cache(int maxRecent) {
        if (maxRecent <= 0) {
            throw new IllegalArgumentException("Max recent must be greater than zero: " + maxRecent);
        }
        this.mMaxRecent = maxRecent;
        this.mUsageMap = new UsageMap();
    }

    public Cache(Cache cache) {
        this.mMaxRecent = cache.mMaxRecent;
        this.mUsageMap = cache.mUsageMap;
    }

    public int getMaxRecent() {
        return this.mMaxRecent;
    }

    @Override
    public Object get(Object key) {
        Object value = super.get(key);
        if (value != null || super.containsKey(key)) {
            this.adjustMRU(key, value);
        }
        return value;
    }

    @Override
    public Object put(Object key, Object value) {
        if (value == null) {
            value = new SoftHashMap.Null();
        }
        this.adjustMRU(key, value);
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        UsageMap usageMap = this.mUsageMap;
        synchronized (usageMap) {
            this.mUsageMap.remove(key);
        }
        return super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        UsageMap usageMap = this.mUsageMap;
        synchronized (usageMap) {
            this.mUsageMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustMRU(Object key, Object value) {
        UsageMap usageMap = this.mUsageMap;
        synchronized (usageMap) {
            Object existing = this.mUsageMap.get(key);
            if (existing != null) {
                if (value == null && existing instanceof SoftHashMap.Null) {
                    value = existing;
                }
            } else if (!this.mUsageMap.containsKey(key)) {
                while (this.mUsageMap.size() >= this.mMaxRecent) {
                    this.mUsageMap.remove(this.mUsageMap.lastKey());
                }
            }
            this.mUsageMap.put(key, value);
        }
    }
}

