/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.teatrove.trove.util.MessageException;
import org.teatrove.trove.util.MessageListener;
import org.teatrove.trove.util.MessageTransceiver;

public class BasicMulticastTransceiverImpl
implements MessageTransceiver {
    private ArrayList mListeners = new ArrayList();
    private InetAddress mGroup = null;
    private InetAddress mBindAddress = null;
    private int mPort = 0;
    private MulticastSocket mSocket = null;
    private PollThread mPollThread = null;
    private static final int SOCKET_POLL_INTERVAL = 100;

    BasicMulticastTransceiverImpl(InetAddress group, int port, InetAddress bindAddress) throws MessageException {
        this.mGroup = group;
        this.mBindAddress = bindAddress;
        this.mPort = port;
        this.mPollThread = new PollThread();
        Thread t = new Thread(this.mPollThread);
        t.start();
        try {
            this.mSocket = new MulticastSocket(new InetSocketAddress(this.mGroup, this.mPort));
            this.mSocket.setSoTimeout(100);
        }
        catch (Exception e) {
            throw new MessageException("Cannot create socket on " + this.mGroup + ":" + this.mPort, e);
        }
        if (this.mBindAddress != null) {
            try {
                this.mSocket.setInterface(this.mBindAddress);
            }
            catch (Exception e) {
                throw new MessageException("Cannot bind socket on interface " + this.mBindAddress, e);
            }
        }
        try {
            this.mSocket.joinGroup(this.mGroup);
        }
        catch (Exception e) {
            throw new MessageException("Cannot join group on " + this.mGroup + ":" + this.mPort, e);
        }
    }

    @Override
    public void shutdown() {
        this.mPollThread.stop();
    }

    @Override
    public void addMessageListener(MessageListener l) {
        this.mListeners.add(l);
    }

    @Override
    public void removeMessageListener(MessageListener l) {
        this.mListeners.remove(l);
    }

    @Override
    public void send(Serializable message) throws MessageException {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buf);
            out.writeObject(message);
            this.mSocket.send(new DatagramPacket(buf.toByteArray(), buf.size(), this.mGroup, this.mPort));
        }
        catch (Exception e) {
            throw new MessageException("Cannot send message on " + this.mGroup + ":" + this.mPort, e);
        }
    }

    private Serializable poll() {
        try {
            byte[] buf = new byte[4096];
            DatagramPacket p = new DatagramPacket(buf, buf.length);
            this.mSocket.receive(p);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buf));
            return (Serializable)in.readObject();
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Message receive failure on " + this.mGroup + ":" + this.mPort, e);
        }
    }

    private class PollThread
    implements Runnable {
        private boolean mRun = true;

        private PollThread() {
        }

        @Override
        public void run() {
            while (this.mRun) {
                Serializable o = BasicMulticastTransceiverImpl.this.poll();
                if (o == null) continue;
                for (MessageListener l : BasicMulticastTransceiverImpl.this.mListeners) {
                    l.onMessage(o);
                }
            }
        }

        public void stop() {
            this.mRun = false;
            try {
                Thread.sleep(101L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

