/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.net.ConnectException;
import java.net.SocketException;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.InetAddressAndPort;
import org.teatrove.trove.net.LazySocket;
import org.teatrove.trove.net.SocketFace;
import org.teatrove.trove.net.SocketFactory;

public class LazySocketFactory
implements SocketFactory {
    private final SocketFactory mFactory;

    public LazySocketFactory(SocketFactory factory) {
        this.mFactory = factory;
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort() {
        return this.mFactory.getInetAddressAndPort();
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort(Object session) {
        return this.mFactory.getInetAddressAndPort(session);
    }

    @Override
    public long getDefaultTimeout() {
        return this.mFactory.getDefaultTimeout();
    }

    @Override
    public CheckedSocket createSocket() throws ConnectException, SocketException {
        return this.mFactory.createSocket();
    }

    @Override
    public CheckedSocket createSocket(Object session) throws ConnectException, SocketException {
        return this.mFactory.createSocket(session);
    }

    @Override
    public CheckedSocket createSocket(long timeout) throws ConnectException, SocketException {
        return this.mFactory.createSocket(timeout);
    }

    @Override
    public CheckedSocket createSocket(Object session, long timeout) throws ConnectException, SocketException {
        return this.mFactory.createSocket(session, timeout);
    }

    @Override
    public CheckedSocket getSocket() throws ConnectException, SocketException {
        return CheckedSocket.check(new LazySocket(this.mFactory));
    }

    @Override
    public CheckedSocket getSocket(Object session) throws ConnectException, SocketException {
        return CheckedSocket.check(new LazySocket(this.mFactory, session));
    }

    @Override
    public CheckedSocket getSocket(long timeout) throws ConnectException, SocketException {
        return CheckedSocket.check(new LazySocket(this.mFactory, timeout));
    }

    @Override
    public CheckedSocket getSocket(Object session, long timeout) throws ConnectException, SocketException {
        return CheckedSocket.check(new LazySocket(this.mFactory, session, timeout));
    }

    @Override
    public void recycleSocket(CheckedSocket cs) throws SocketException, IllegalArgumentException {
        if (cs == null) {
            return;
        }
        SocketFace s = cs.mSocket;
        if (s instanceof LazySocket && (cs = ((LazySocket)s).recycle()) == null) {
            return;
        }
        this.mFactory.recycleSocket(cs);
    }

    @Override
    public void clear() {
        this.mFactory.clear();
    }

    @Override
    public int getAvailableCount() {
        return this.mFactory.getAvailableCount();
    }
}

