/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketException;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.CharToByteBuffer;
import org.teatrove.trove.io.DefaultByteBuffer;
import org.teatrove.trove.io.FastBufferedInputStream;
import org.teatrove.trove.io.FastBufferedOutputStream;
import org.teatrove.trove.io.FastCharToByteBuffer;
import org.teatrove.trove.io.InternedCharToByteBuffer;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.HttpHeaderMap;
import org.teatrove.trove.net.HttpUtils;
import org.teatrove.trove.net.SocketFactory;

public class HttpClient {
    private final SocketFactory mFactory;
    private final int mReadTimeout;
    private String mMethod = "GET";
    private String mURI = "";
    private String mProtocol = "HTTP/1.0";
    private HttpHeaderMap mHeaders;
    private Object mSession;

    public HttpClient(SocketFactory factory) {
        this(factory, factory.getDefaultTimeout());
    }

    public HttpClient(SocketFactory factory, long readTimeout) {
        this.mFactory = factory;
        this.mReadTimeout = readTimeout == 0L ? 1 : (readTimeout < 0L ? 0 : (readTimeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)readTimeout));
    }

    public HttpClient setMethod(String method) {
        this.mMethod = method;
        return this;
    }

    public HttpClient setURI(String uri) {
        this.mURI = uri;
        return this;
    }

    public HttpClient setProtocol(String protocol) {
        this.mProtocol = protocol;
        return this;
    }

    public HttpClient setHeader(String name, Object value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HttpHeaderMap();
        }
        this.mHeaders.put(name, value);
        return this;
    }

    public HttpClient addHeader(String name, Object value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HttpHeaderMap();
        }
        this.mHeaders.add(name, value);
        return this;
    }

    public HttpClient setHeaders(HttpHeaderMap headers) {
        this.mHeaders = headers;
        return this;
    }

    public HttpClient setPersistent(boolean b) {
        if (b) {
            this.setHeader("Connection", "Keep-Alive");
        } else {
            this.setHeader("Connection", "Close");
        }
        return this;
    }

    public HttpClient preparePost(int contentLength) {
        this.setMethod("POST");
        this.setHeader("Content-Type", "application/x-www-form-urlencoded");
        this.setHeader("Content-Length", new Integer(contentLength));
        return this;
    }

    public HttpClient setSession(Object session) {
        this.mSession = session;
        return this;
    }

    public Response getResponse() throws ConnectException, SocketException {
        return this.getResponse(null);
    }

    public Response getResponse(PostData postData) throws ConnectException, SocketException {
        CheckedSocket socket = this.mFactory.getSocket(this.mSession);
        try {
            Response response;
            CharToByteBuffer request = new FastCharToByteBuffer(new DefaultByteBuffer(), "8859_1");
            request = new InternedCharToByteBuffer(request);
            request.append(this.mMethod);
            request.append(' ');
            request.append(this.mURI);
            request.append(' ');
            request.append(this.mProtocol);
            request.append("\r\n");
            if (this.mHeaders != null) {
                this.mHeaders.appendTo(request);
            }
            request.append("\r\n");
            try {
                response = this.sendRequest(socket, request, postData);
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                response = null;
            }
            if (response == null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                socket = this.mFactory.createSocket(this.mSession);
                response = this.sendRequest(socket, request, postData);
                if (response == null) {
                    throw new ConnectException("No response from server " + socket.getInetAddress() + ":" + socket.getPort());
                }
            }
            return response;
        }
        catch (SocketException e) {
            throw e;
        }
        catch (InterruptedIOException e) {
            throw new ConnectException("Read timeout expired: " + this.mReadTimeout + ", " + e);
        }
        catch (IOException e) {
            throw new SocketException(e.toString());
        }
    }

    private Response sendRequest(CheckedSocket socket, ByteBuffer request, PostData postData) throws SocketException, IOException {
        socket.setSoTimeout(this.mReadTimeout);
        FastBufferedOutputStream out = new FastBufferedOutputStream(socket.getOutputStream());
        request.writeTo(out);
        if (postData != null) {
            this.writePostData(out, postData);
        }
        ((OutputStream)out).flush();
        FastBufferedInputStream in = new FastBufferedInputStream(socket.getInputStream());
        char[] buf = new char[100];
        String line = HttpUtils.readLine((InputStream)in, buf);
        if (line == null) {
            return null;
        }
        return new Response(socket, this.mMethod, in, buf, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePostData(OutputStream out, PostData postData) throws IOException {
        block9: {
            Integer i;
            InputStream in = postData.getInputStream();
            int contentLength = -1;
            if (this.mHeaders != null && (i = this.mHeaders.getInteger("Content-Length")) != null) {
                contentLength = i;
            }
            byte[] buf = contentLength < 0 || contentLength > 4000 ? new byte[4000] : new byte[contentLength];
            try {
                if (contentLength < 0) {
                    int len;
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    break block9;
                }
                while (contentLength > 0) {
                    int len = buf.length;
                    if (contentLength < len) {
                        len = contentLength;
                    }
                    if ((len = in.read(buf, 0, len)) <= 0) {
                        break;
                    }
                    out.write(buf, 0, len);
                    contentLength -= len;
                }
            }
            finally {
                in.close();
            }
        }
    }

    private class ResponseInput
    extends InputStream {
        private CheckedSocket mSocket;
        private InputStream mIn;
        private int mContentLength;

        public ResponseInput(CheckedSocket socket, InputStream in, int contentLength) throws IOException {
            this.mSocket = socket;
            this.mIn = in;
            this.mContentLength = contentLength;
            if (this.mContentLength == 0) {
                this.recycle();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.mContentLength == 0) {
                return -1;
            }
            int b = this.mIn.read();
            if (b < 0) {
                this.close();
            } else if (this.mContentLength > 0 && --this.mContentLength == 0) {
                this.recycle();
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.mContentLength == 0) {
                return -1;
            }
            if (this.mContentLength < 0) {
                if ((len = this.mIn.read(b, off, len)) < 0) {
                    this.close();
                } else if (len == 0) {
                    this.close();
                    len = -1;
                }
                return len;
            }
            if (len > this.mContentLength) {
                len = this.mContentLength;
            } else if (len == 0) {
                return 0;
            }
            len = this.mIn.read(b, off, len);
            if (len < 0) {
                this.close();
            } else if (len == 0) {
                this.close();
                len = -1;
            } else if ((this.mContentLength -= len) == 0) {
                this.recycle();
            }
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.mContentLength == 0) {
                return 0L;
            }
            if (this.mContentLength < 0) {
                return this.mIn.skip(n);
            }
            if (n > (long)this.mContentLength) {
                n = this.mContentLength;
            } else if (n == 0L) {
                return 0L;
            }
            n = this.mIn.skip(n);
            this.mContentLength = (int)((long)this.mContentLength - n);
            if (this.mContentLength == 0) {
                this.recycle();
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            if (this.mContentLength == 0) {
                return 0;
            }
            try {
                return this.mIn.available();
            }
            catch (SocketException se) {
                return 0;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.mSocket != null) {
                this.mContentLength = 0;
                this.mSocket = null;
                this.mIn.close();
            }
        }

        private void recycle() throws IOException {
            if (this.mSocket != null) {
                if (this.mContentLength == 0) {
                    CheckedSocket s = this.mSocket;
                    this.mSocket = null;
                    HttpClient.this.mFactory.recycleSocket(s);
                } else {
                    this.mSocket = null;
                    this.mIn.close();
                }
            }
        }
    }

    public class Response {
        private final CheckedSocket mSocket;
        private final String mRequestMethod;
        private final InputStream mRawIn;
        private int mStatusCode;
        private String mStatusMessage;
        private HttpHeaderMap mHeaders;
        private InputStream mIn;

        Response(CheckedSocket socket, String method, InputStream in, char[] buf, String line) throws IOException {
            this.mSocket = socket;
            this.mRequestMethod = method;
            this.mRawIn = in;
            this.nextResponse(buf, line);
        }

        public void close() {
            try {
                this.mSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public String getStatusMessage() {
            return this.mStatusMessage;
        }

        public HttpHeaderMap getHeaders() {
            return this.mHeaders;
        }

        public boolean hasNextResponse() {
            return this.mStatusCode == 100;
        }

        public boolean nextResponse() throws IOException {
            if (this.mStatusCode != 100) {
                return false;
            }
            char[] buf = new char[100];
            String line = HttpUtils.readLine(this.mRawIn, buf);
            if (line == null) {
                throw new ProtocolException("No next response");
            }
            this.nextResponse(buf, line);
            return true;
        }

        public InputStream getInputStream() throws IOException {
            Integer i;
            if (this.mIn != null) {
                return this.mIn;
            }
            while (this.nextResponse()) {
            }
            int contentLength = "Keep-Alive".equalsIgnoreCase(this.mHeaders.getString("Connection")) ? ("HEAD".equals(this.mRequestMethod) ? 0 : ((i = this.mHeaders.getInteger("Content-Length")) != null ? i : -1)) : -1;
            this.mIn = new ResponseInput(this.mSocket, this.mRawIn, contentLength);
            return this.mIn;
        }

        private void nextResponse(char[] buf, String line) throws IOException {
            int statusCode = -1;
            String statusMessage = "";
            int space = line.indexOf(32);
            if (space > 0) {
                String sub;
                int nextSpace = line.indexOf(32, space + 1);
                if (nextSpace < 0) {
                    sub = line.substring(space + 1);
                } else {
                    sub = line.substring(space + 1, nextSpace);
                    statusMessage = line.substring(nextSpace + 1);
                }
                try {
                    statusCode = Integer.parseInt(sub);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (statusCode < 0) {
                throw new ProtocolException("Invalid HTTP response: " + line);
            }
            this.mStatusCode = statusCode;
            this.mStatusMessage = statusMessage;
            this.mHeaders = new HttpHeaderMap();
            this.mHeaders.readFrom(this.mRawIn, buf);
        }
    }

    public static interface PostData {
        public InputStream getInputStream() throws IOException;
    }
}

