/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.InetAddressAndPort;
import org.teatrove.trove.net.SocketFactory;
import org.teatrove.trove.util.IdentityMap;

public class DistributedSocketFactory
implements SocketFactory {
    private final long mTimeout;
    private Random mRnd;
    private int mFactoryIndex;
    private List mFactories;
    private Map mResurrectors;
    private Map mSocketSources;
    private CheckedSocket.ExceptionListener mListener;

    public DistributedSocketFactory(long timeout) {
        this(timeout, null);
    }

    public DistributedSocketFactory(long timeout, Random rnd) {
        this.mTimeout = timeout;
        this.mRnd = rnd;
        this.mFactories = Collections.synchronizedList(new ArrayList());
        this.mResurrectors = Collections.synchronizedMap(new HashMap());
        this.mSocketSources = Collections.synchronizedMap(new IdentityMap());
        this.mListener = new CheckedSocket.ExceptionListener(){

            @Override
            public void exceptionOccurred(CheckedSocket s, Exception e, int count) {
                if (count == 1) {
                    DistributedSocketFactory.this.deadFactory((SocketFactory)DistributedSocketFactory.this.mSocketSources.get(s));
                }
            }
        };
    }

    public void addSocketFactory(SocketFactory factory) {
        this.mFactories.add(factory);
    }

    public void removeSocketFactory(SocketFactory factory) {
        this.mFactories.remove(factory);
        Thread t = (Thread)this.mResurrectors.remove(factory);
        if (t != null) {
            t.interrupt();
        }
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort() {
        try {
            return this.getFactory(this.selectFactoryIndex(null)).getInetAddressAndPort();
        }
        catch (ConnectException e) {
            return InetAddressAndPort.UNKNOWN;
        }
    }

    @Override
    public InetAddressAndPort getInetAddressAndPort(Object session) {
        try {
            return this.getFactory(this.selectFactoryIndex(session)).getInetAddressAndPort(session);
        }
        catch (ConnectException e) {
            return InetAddressAndPort.UNKNOWN;
        }
    }

    @Override
    public long getDefaultTimeout() {
        return this.mTimeout;
    }

    @Override
    public CheckedSocket createSocket() throws ConnectException, SocketException {
        return this.createSocket(null, this.mTimeout);
    }

    @Override
    public CheckedSocket createSocket(Object session) throws ConnectException, SocketException {
        return this.createSocket(session, this.mTimeout);
    }

    @Override
    public CheckedSocket createSocket(long timeout) throws ConnectException, SocketException {
        return this.createSocket(null, timeout);
    }

    @Override
    public CheckedSocket createSocket(Object session, long timeout) throws ConnectException, SocketException {
        long startTime = timeout > 0L ? System.currentTimeMillis() : 0L;
        int index = this.selectFactoryIndex(session);
        int count = this.mFactories.size();
        for (int i = 0; i < count; ++i) {
            SocketFactory factory = null;
            try {
                factory = this.getFactory(index++);
                CheckedSocket socket = factory.createSocket(session, timeout);
                socket.addExceptionListener(this.mListener);
                this.mSocketSources.put(socket, factory);
                return socket;
            }
            catch (SocketException e) {
                this.deadFactory(factory);
                if (timeout == 0L) {
                    throw e;
                }
                if (timeout <= 0L || (timeout -= System.currentTimeMillis() - startTime) >= 0L) continue;
                throw e;
            }
        }
        throw new ConnectException("Unable to create socket");
    }

    @Override
    public CheckedSocket getSocket() throws ConnectException, SocketException {
        return this.getSocket(null, this.mTimeout);
    }

    @Override
    public CheckedSocket getSocket(Object session) throws ConnectException, SocketException {
        return this.getSocket(session, this.mTimeout);
    }

    @Override
    public CheckedSocket getSocket(long timeout) throws ConnectException, SocketException {
        return this.getSocket(null, timeout);
    }

    @Override
    public CheckedSocket getSocket(Object session, long timeout) throws ConnectException, SocketException {
        long startTime = timeout > 0L ? System.currentTimeMillis() : 0L;
        int index = this.selectFactoryIndex(session);
        int count = this.mFactories.size();
        for (int i = 0; i < count; ++i) {
            SocketFactory factory = null;
            try {
                factory = this.getFactory(index++);
                CheckedSocket socket = factory.getSocket(session, timeout);
                socket.addExceptionListener(this.mListener);
                this.mSocketSources.put(socket, factory);
                return socket;
            }
            catch (SocketException e) {
                this.deadFactory(factory);
                if (timeout == 0L) {
                    throw e;
                }
                if (timeout <= 0L || (timeout -= System.currentTimeMillis() - startTime) >= 0L) continue;
                throw e;
            }
        }
        throw new ConnectException("Unable to get socket");
    }

    @Override
    public void recycleSocket(CheckedSocket socket) throws SocketException, IllegalArgumentException {
        if (socket == null) {
            return;
        }
        SocketFactory source = (SocketFactory)this.mSocketSources.remove(socket);
        if (source == null) {
            throw new IllegalArgumentException("Socket did not originate from this pool");
        }
        socket.removeExceptionListener(this.mListener);
        source.recycleSocket(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.mFactories;
        synchronized (list) {
            int i = this.mFactories.size();
            while (--i >= 0) {
                ((SocketFactory)this.mFactories.get(i)).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAvailableCount() {
        int count = 0;
        List list = this.mFactories;
        synchronized (list) {
            int i = this.mFactories.size();
            while (--i >= 0) {
                count += ((SocketFactory)this.mFactories.get(i)).getAvailableCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int selectFactoryIndex(Object session) throws ConnectException {
        if (session != null) {
            return session.hashCode() & Integer.MAX_VALUE;
        }
        Random rnd = this.mRnd;
        if (rnd != null) {
            return rnd.nextInt() >>> 1;
        }
        List list = this.mFactories;
        synchronized (list) {
            return this.mFactoryIndex++ & Integer.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketFactory getFactory(int index) throws ConnectException {
        List list = this.mFactories;
        synchronized (list) {
            int size = this.mFactories.size();
            if (size <= 0) {
                throw new ConnectException("No SocketFactories available");
            }
            return (SocketFactory)this.mFactories.get(index % size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deadFactory(SocketFactory factory) {
        if (factory == null) {
            return;
        }
        List list = this.mFactories;
        synchronized (list) {
            if (this.mFactories.contains(factory) && this.mFactories.size() > 1) {
                this.mFactories.remove(factory);
                Resurrector r = new Resurrector(this, factory);
                Thread t = new Thread(null, r, "Resurrector " + factory.getInetAddressAndPort());
                t.setDaemon(true);
                t.start();
                this.mResurrectors.put(factory, t);
            }
        }
    }

    private static class Resurrector
    implements Runnable {
        private final Reference mOwner;
        private final SocketFactory mFactory;

        public Resurrector(DistributedSocketFactory owner, SocketFactory factory) {
            this.mOwner = new WeakReference<DistributedSocketFactory>(owner);
            this.mFactory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DistributedSocketFactory owner = null;
            try {
                while (!Thread.interrupted()) {
                    owner = (DistributedSocketFactory)this.mOwner.get();
                    if (owner == null) {
                    } else {
                        try {
                            this.mFactory.recycleSocket(this.mFactory.createSocket());
                            owner.mFactories.add(this.mFactory);
                        }
                        catch (IOException e) {
                            owner = null;
                            try {
                                Thread.sleep(5000L);
                                continue;
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
            }
            finally {
                owner = (DistributedSocketFactory)this.mOwner.get();
                if (owner != null) {
                    owner.mResurrectors.remove(this.mFactory);
                }
            }
        }
    }
}

