/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogEventParsingWriter;
import org.teatrove.trove.log.LogListener;

public class Log
implements LogListener,
Serializable {
    private static final int ENABLED_MASK = 1;
    private static final int DEBUG_ENABLED_MASK = 2;
    private static final int INFO_ENABLED_MASK = 4;
    private static final int WARN_ENABLED_MASK = 8;
    private static final int ERROR_ENABLED_MASK = 16;
    private final transient PrintWriter mDebug;
    private final transient PrintWriter mInfo;
    private final transient PrintWriter mWarn;
    private final transient PrintWriter mError;
    private Log mParent;
    private Collection mChildren = new ArrayList();
    private String mName;
    private String mDescription;
    private int mEnabledFlags = 0xFFFFFFF;
    protected transient List mListeners = Collections.synchronizedList(new ArrayList());

    public Log(String name, Log parent) {
        this();
        if (parent != null) {
            this.mParent = parent;
            parent.mChildren.add(new WeakReference<Log>(this));
            this.mEnabledFlags = parent.mEnabledFlags;
            this.addLogListener(parent);
        }
        this.mName = name;
        this.mDescription = name;
    }

    private Log() {
        LogEventParsingWriter writer = new LogEventParsingWriter(this, 1, this){

            @Override
            public boolean isEnabled() {
                return Log.this.isDebugEnabled();
            }
        };
        writer.addLogListener(this);
        this.mDebug = new PrintWriter((Writer)writer, true);
        writer = new LogEventParsingWriter(this, 2, this){

            @Override
            public boolean isEnabled() {
                return Log.this.isInfoEnabled();
            }
        };
        writer.addLogListener(this);
        this.mInfo = new PrintWriter((Writer)writer, true);
        writer = new LogEventParsingWriter(this, 3, this){

            @Override
            public boolean isEnabled() {
                return Log.this.isWarnEnabled();
            }
        };
        writer.addLogListener(this);
        this.mWarn = new PrintWriter((Writer)writer, true);
        writer = new LogEventParsingWriter(this, 4, this){

            @Override
            public boolean isEnabled() {
                return Log.this.isErrorEnabled();
            }
        };
        writer.addLogListener(this);
        this.mError = new PrintWriter((Writer)writer, true);
    }

    public void addRootLogListener(LogListener listener) {
        if (this.mParent == null) {
            this.addLogListener(listener);
        } else {
            this.mParent.addRootLogListener(listener);
        }
    }

    public void removeRootLogListener(LogListener listener) {
        this.mListeners.remove(listener);
        if (this.mParent == null) {
            this.removeLogListener(listener);
        } else {
            this.mParent.removeRootLogListener(listener);
        }
    }

    public void addLogListener(LogListener listener) {
        this.mListeners.add(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.mListeners.remove(listener);
    }

    public void removeAllLogListeners() {
        this.mListeners = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void logMessage(LogEvent e) {
        if (this.isEnabled()) {
            this.dispatchLogMessage(e);
        }
    }

    @Override
    public void logException(LogEvent e) {
        if (this.isEnabled()) {
            this.dispatchLogException(e);
        }
    }

    private void dispatchLogMessage(LogEvent e) {
        int size = this.mListeners.size();
        try {
            for (int i = 0; i < size; ++i) {
                ((LogListener)this.mListeners.get(i)).logMessage(e);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void dispatchLogException(LogEvent e) {
        int size = this.mListeners.size();
        try {
            for (int i = 0; i < size; ++i) {
                ((LogListener)this.mListeners.get(i)).logException(e);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public PrintWriter debug() {
        return this.mDebug;
    }

    public void debug(String s) {
        if (this.isEnabled() && this.isDebugEnabled()) {
            this.dispatchLogMessage(new LogEvent(this, 1, s));
        }
    }

    public void debug(Throwable t) {
        if (this.isEnabled() && this.isDebugEnabled()) {
            this.dispatchLogException(new LogEvent(this, 1, t));
        }
    }

    public PrintWriter info() {
        return this.mInfo;
    }

    public void info(String s) {
        if (this.isEnabled() && this.isInfoEnabled()) {
            this.dispatchLogMessage(new LogEvent(this, 2, s));
        }
    }

    public void info(Throwable t) {
        if (this.isEnabled() && this.isInfoEnabled()) {
            this.dispatchLogException(new LogEvent(this, 2, t));
        }
    }

    public PrintWriter warn() {
        return this.mWarn;
    }

    public void warn(String s) {
        if (this.isEnabled() && this.isWarnEnabled()) {
            this.dispatchLogMessage(new LogEvent(this, 3, s));
        }
    }

    public void warn(Throwable t) {
        if (this.isEnabled() && this.isWarnEnabled()) {
            this.dispatchLogException(new LogEvent(this, 3, t));
        }
    }

    public PrintWriter error() {
        return this.mError;
    }

    public void error(String s) {
        if (this.isEnabled() && this.isErrorEnabled()) {
            this.dispatchLogMessage(new LogEvent(this, 4, s));
        }
    }

    public void error(Throwable t) {
        if (this.isEnabled() && this.isErrorEnabled()) {
            this.dispatchLogException(new LogEvent(this, 4, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log[] getChildren() {
        ArrayList<Log> copy;
        Collection collection = this.mChildren;
        synchronized (collection) {
            copy = new ArrayList<Log>(this.mChildren.size());
            Iterator it = this.mChildren.iterator();
            while (it.hasNext()) {
                Log child = (Log)((WeakReference)it.next()).get();
                if (child == null) {
                    it.remove();
                    continue;
                }
                copy.add(child);
            }
        }
        return copy.toArray(new Log[copy.size()]);
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public boolean isEnabled() {
        return this.isEnabled(1);
    }

    public void setEnabled(boolean enabled) {
        Log parent;
        this.setEnabled(enabled, 1);
        if (enabled && (parent = this.mParent) != null) {
            parent.setEnabled(true);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(2);
    }

    public void setDebugEnabled(boolean enabled) {
        this.setEnabled(enabled, 2);
        if (enabled) {
            this.setEnabled(true);
        }
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(4);
    }

    public void setInfoEnabled(boolean enabled) {
        this.setEnabled(enabled, 4);
        if (enabled) {
            this.setEnabled(true);
        }
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(8);
    }

    public void setWarnEnabled(boolean enabled) {
        this.setEnabled(enabled, 8);
        if (enabled) {
            this.setEnabled(true);
        }
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(16);
    }

    public void setErrorEnabled(boolean enabled) {
        this.setEnabled(enabled, 16);
        if (enabled) {
            this.setEnabled(true);
        }
    }

    public void applyProperties(Map properties) {
        if (properties.containsKey("enabled")) {
            this.setEnabled(!"false".equalsIgnoreCase((String)properties.get("enabled")));
        }
        if (properties.containsKey("debug")) {
            this.setDebugEnabled(!"false".equalsIgnoreCase((String)properties.get("debug")));
        }
        if (properties.containsKey("info")) {
            this.setInfoEnabled(!"false".equalsIgnoreCase((String)properties.get("info")));
        }
        if (properties.containsKey("warn")) {
            this.setWarnEnabled(!"false".equalsIgnoreCase((String)properties.get("warn")));
        }
        if (properties.containsKey("error")) {
            this.setErrorEnabled(!"false".equalsIgnoreCase((String)properties.get("error")));
        }
    }

    public String toString() {
        return "Log[" + this.getDescription() + "]@" + Integer.toHexString(this.hashCode());
    }

    private boolean isEnabled(int mask) {
        return (this.mEnabledFlags & mask) == mask;
    }

    private void setEnabled(boolean enabled, int mask) {
        this.mEnabledFlags = enabled ? (this.mEnabledFlags |= mask) : (this.mEnabledFlags &= ~mask);
    }
}

