/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.Reader;
import org.teatrove.trove.io.PositionReader;

public class PushbackPositionReader
extends PositionReader {
    private int mMaxPushback = pushback += 2;
    private int[] mCharacters;
    private int[] mPositions;
    private int mCursor;
    private int mPushback;

    public PushbackPositionReader(Reader reader) {
        this(reader, 0);
    }

    public PushbackPositionReader(Reader reader, int pushback) {
        super(reader);
        this.mCharacters = new int[pushback];
        this.mPositions = new int[pushback];
        this.mCursor = 0;
        this.mPushback = 0;
    }

    public int getStartPosition() {
        int back = this.mCursor - 2;
        if (back < 0) {
            back += this.mMaxPushback;
        }
        return this.mPositions[back];
    }

    @Override
    public int read() throws IOException {
        if (this.mPushback > 0) {
            --this.mPushback;
            this.mPosition = this.mPositions[this.mCursor];
            int c = this.mCharacters[this.mCursor++];
            if (this.mCursor >= this.mMaxPushback) {
                this.mCursor = 0;
            }
            return c;
        }
        int c = super.read();
        this.mPositions[this.mCursor] = this.mPosition;
        this.mCharacters[this.mCursor++] = c;
        if (this.mCursor >= this.mMaxPushback) {
            this.mCursor = 0;
        }
        return c;
    }

    public int peek() throws IOException {
        int c = this.read();
        this.unread();
        return c;
    }

    public void unread(int amount) throws IOException {
        for (int i = 0; i < amount; ++i) {
            this.unread();
        }
    }

    public void unread() throws IOException {
        ++this.mPushback;
        if (this.mPushback > this.mMaxPushback - 2) {
            throw new IOException(this.getClass().getName() + ": pushback exceeded " + (this.mMaxPushback - 2));
        }
        if (--this.mCursor < 0) {
            this.mCursor += this.mMaxPushback;
        }
        this.mPosition = this.mCursor > 0 ? this.mPositions[this.mCursor - 1] : this.mPositions[this.mMaxPushback - 1];
        this.unreadHook(this.mCharacters[this.mCursor]);
    }

    protected void unreadHook(int c) {
    }
}

