/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.IOException;
import org.teatrove.trove.file.Bitlist;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.file.NonTxFileBuffer;
import org.teatrove.trove.file.TxFileBuffer;

public class TaggedTxFileBuffer
extends NonTxFileBuffer
implements TxFileBuffer {
    private final Bitlist mBitlist;
    private final long mBitlistPos;
    private int mTranCount;
    private boolean mClosing;

    public TaggedTxFileBuffer(FileBuffer dataFile, Bitlist bitlist, long bitlistPosition) {
        super(dataFile);
        this.mBitlist = bitlist;
        this.mBitlistPos = bitlistPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long size) throws IOException {
        super.truncate(size);
        if (size == 0L) {
            TaggedTxFileBuffer taggedTxFileBuffer = this;
            synchronized (taggedTxFileBuffer) {
                this.mTranCount = 0;
                this.mBitlist.clear(this.mBitlistPos);
            }
        }
    }

    @Override
    public synchronized boolean force() throws IOException {
        if (this.mTranCount > 0) {
            return this.mBitlist.force() & this.mFile.force();
        }
        return this.mFile.force() & this.mBitlist.force();
    }

    @Override
    public synchronized void close() throws IOException {
        this.mFile.close();
    }

    @Override
    public synchronized void close(long timeout) throws IOException {
        if (!this.mFile.isOpen()) {
            return;
        }
        this.mClosing = true;
        if (timeout != 0L && this.mTranCount > 0) {
            try {
                if (timeout < 0L) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mFile.close();
        this.mClosing = false;
    }

    @Override
    public synchronized boolean isClean() throws IOException {
        return this.mTranCount == 0 && !this.mBitlist.get(this.mBitlistPos);
    }

    @Override
    public synchronized void begin() throws IOException {
        if (!this.mFile.isOpen()) {
            throw new IOException("FileBuffer closed");
        }
        if (this.mTranCount <= 0) {
            if (this.mClosing) {
                throw new IOException("FileBuffer closing");
            }
            this.mTranCount = 1;
            this.mBitlist.set(this.mBitlistPos);
        } else {
            ++this.mTranCount;
        }
    }

    @Override
    public synchronized boolean commit() throws IOException {
        if (this.mTranCount > 0) {
            if (--this.mTranCount <= 0) {
                this.mBitlist.clear(this.mBitlistPos);
                this.notifyAll();
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean rollback() {
        this.notifyAll();
        throw new UnsupportedOperationException();
    }
}

