/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.NoSuchElementException;
import org.teatrove.trove.file.Bitlist;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.file.FileBufferInputStream;
import org.teatrove.trove.file.FileBufferOutputStream;
import org.teatrove.trove.file.FileRepository;
import org.teatrove.trove.file.MultiplexFile;
import org.teatrove.trove.util.ReadWriteLock;

public class MultiplexFileRepository
implements FileRepository {
    private final MultiplexFile mMF;
    private final FileBuffer mFreeIds;
    private final Bitlist mFreeIdBitlist;
    private final FileBufferInputStream mFreeIdsIn;
    private final FileBufferOutputStream mFreeIdsOut;
    private final ReadWriteLock mLock;

    public MultiplexFileRepository(MultiplexFile mf) throws IOException {
        this(mf, 1);
    }

    public MultiplexFileRepository(MultiplexFile mf, int firstId) throws IOException {
        this.mMF = mf;
        if (firstId <= 0) {
            firstId = 1;
        }
        this.mFreeIds = mf.openFile(firstId);
        this.mFreeIdBitlist = new Bitlist(mf.openFile(firstId + 1));
        this.mFreeIdsIn = new FileBufferInputStream(this.mFreeIds);
        this.mFreeIdsOut = new FileBufferOutputStream(this.mFreeIds);
        this.mLock = this.mFreeIds.lock();
    }

    @Override
    public long fileCount() throws IOException {
        try {
            this.mLock.acquireReadLock();
            long l = this.mFreeIdBitlist.size() - this.mFreeIds.size() / 8L;
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public FileRepository.Iterator fileIds() throws IOException {
        return new Iter();
    }

    @Override
    public boolean fileExists(long id) throws IOException {
        try {
            this.mLock.acquireReadLock();
            boolean bl = this.mFreeIdBitlist.get(id);
            return bl;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public FileBuffer openFile(long id) throws IOException, FileNotFoundException {
        try {
            this.mLock.acquireReadLock();
            if (!this.mFreeIdBitlist.get(id)) {
                throw new FileNotFoundException(String.valueOf(id));
            }
            FileBuffer fileBuffer = this.mMF.openFile(id);
            return fileBuffer;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public long createFile() throws IOException {
        try {
            long id;
            this.mLock.acquireWriteLock();
            if (this.mFreeIds.size() < 8L) {
                id = this.mMF.getFileCount();
                this.mMF.openFile(id).close();
            } else {
                long pos = this.mFreeIds.size() - 8L;
                this.mFreeIdsIn.position(pos);
                id = this.mFreeIdsIn.readLong();
                this.mFreeIds.truncate(pos);
            }
            this.mFreeIdBitlist.set(id);
            long l = id;
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(long id) throws IOException {
        block8: {
            try {
                this.mLock.acquireUpgradableLock();
                if (!this.mFreeIdBitlist.get(id)) break block8;
                this.mLock.acquireWriteLock();
                try {
                    this.mMF.deleteFile(id);
                    this.mFreeIdBitlist.clear(id);
                    long pos = this.mFreeIds.size();
                    this.mFreeIdsOut.position(pos);
                    this.mFreeIdsOut.writeLong(id);
                }
                finally {
                    this.mLock.releaseLock();
                }
                boolean pos = true;
                return pos;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.mLock.releaseLock();
            }
        }
        return false;
    }

    @Override
    public ReadWriteLock lock() {
        return this.mLock;
    }

    public int getBlockSize() {
        return this.mMF.getBlockSize();
    }

    public int getBlockIdScale() {
        return this.mMF.getBlockIdScale();
    }

    public int getLengthScale() {
        return this.mMF.getLengthScale();
    }

    public long getMaximumFileLength() {
        return this.mMF.getMaximumFileLength();
    }

    private class Iter
    implements FileRepository.Iterator {
        private byte[] mTemp = new byte[32];
        private long mIndex;

        Iter() throws IOException {
            this.mIndex = MultiplexFileRepository.this.mFreeIdBitlist.findFirstSet(0L, this.mTemp);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.mIndex >= 0L;
        }

        @Override
        public long next() throws IOException {
            if (this.mIndex < 0L) {
                throw new NoSuchElementException();
            }
            long index = this.mIndex;
            this.mIndex = MultiplexFileRepository.this.mFreeIdBitlist.findFirstSet(index + 1L, this.mTemp);
            return index;
        }
    }
}

