/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.DataInput;
import java.io.IOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.io.AbstractDataInputStream;

public class FileBufferInputStream
extends AbstractDataInputStream
implements DataInput {
    private FileBuffer mFileBuffer;
    private long mPosition;
    private long mMark;
    private final boolean mCloseBuffer;

    public FileBufferInputStream(FileBuffer fb) {
        this(fb, 0L, true);
    }

    public FileBufferInputStream(FileBuffer fb, long position, boolean closeBuffer) {
        this.mFileBuffer = fb;
        this.mPosition = position;
        this.mCloseBuffer = closeBuffer;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        int value = this.mFileBuffer.read(this.mPosition);
        if (value >= 0) {
            ++this.mPosition;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int amt;
        this.checkClosed();
        if (length == 0) {
            return 0;
        }
        int originalOffset = offset;
        while ((amt = this.mFileBuffer.read(this.mPosition, b, offset, length)) > 0) {
            this.mPosition += (long)amt;
            offset += amt;
            if ((length -= amt) > 0) continue;
        }
        amt = offset - originalOffset;
        return amt == 0 ? -1 : amt;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long newPos = this.mPosition + n;
        long size = this.mFileBuffer.size();
        if (newPos > size) {
            newPos = size;
            n = newPos - this.mPosition;
        }
        this.mPosition = newPos;
        return n;
    }

    @Override
    public int available() throws IOException {
        long avail = this.mFileBuffer.size() - this.mPosition;
        if (avail > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (avail <= 0L) {
            return 0;
        }
        return (int)avail;
    }

    @Override
    public void mark(int readlimit) {
        this.mMark = this.mPosition;
    }

    @Override
    public void reset() {
        this.mPosition = this.mMark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.mFileBuffer != null) {
            if (this.mCloseBuffer) {
                this.mFileBuffer.close();
            }
            this.mFileBuffer = null;
        }
    }

    public boolean isOpen() {
        return this.mFileBuffer != null;
    }

    public long position() throws IOException {
        this.checkClosed();
        return this.mPosition;
    }

    public void position(long position) throws IOException {
        this.checkClosed();
        if (position < 0L) {
            throw new IllegalArgumentException("Position < 0: " + position);
        }
        this.mPosition = position;
    }

    @Override
    public String readLine() throws IOException {
        int c;
        StringBuffer buf = null;
        block4: while ((c = this.read()) >= 0) {
            if (buf == null) {
                buf = new StringBuffer(128);
            }
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    long oldPos = this.mPosition;
                    int c2 = this.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    this.mPosition = oldPos;
                    break block4;
                }
                default: {
                    buf.append((char)c);
                    continue block4;
                }
            }
        }
        return buf == null ? null : buf.toString();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private void checkClosed() throws IOException {
        if (this.mFileBuffer == null) {
            throw new IOException("Stream closed");
        }
    }
}

