/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile.generics;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.teatrove.trove.classfile.MethodDesc;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.classfile.generics.AbstractGenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeFactory;
import org.teatrove.trove.classfile.generics.InternFactory;

public class TypeVariableDesc
extends AbstractGenericTypeDesc<TypeVariable<?>> {
    private final String name;
    private final GenericDeclarationDesc declaration;
    private GenericTypeDesc bounds;

    public static TypeVariableDesc forType(String name, String className) {
        return InternFactory.intern(new TypeVariableDesc(name, TypeVariableDesc.forDeclaration(className)));
    }

    public static TypeVariableDesc forType(String name, String className, GenericTypeDesc bounds) {
        return InternFactory.intern(new TypeVariableDesc(name, TypeVariableDesc.forDeclaration(className), bounds));
    }

    public static TypeVariableDesc forType(String name, String className, String methodName, MethodDesc method) {
        return InternFactory.intern(new TypeVariableDesc(name, TypeVariableDesc.forDeclaration(className, methodName, method)));
    }

    public static TypeVariableDesc forType(String name, String className, String methodName, MethodDesc method, GenericTypeDesc bounds) {
        return InternFactory.intern(new TypeVariableDesc(name, TypeVariableDesc.forDeclaration(className, methodName, method), bounds));
    }

    public static TypeVariableDesc forType(TypeVariable<?> variable) {
        TypeVariableDesc desc = new TypeVariableDesc(variable);
        TypeVariableDesc var = InternFactory.intern(desc);
        if (desc == var) {
            var.resolve(variable);
        }
        return var;
    }

    protected TypeVariableDesc(String name, GenericDeclarationDesc declaration) {
        this.name = name;
        this.declaration = declaration;
    }

    protected TypeVariableDesc(String name, GenericDeclarationDesc declaration, GenericTypeDesc bounds) {
        this.name = name;
        this.declaration = declaration;
        this.bounds = bounds;
    }

    protected TypeVariableDesc(TypeVariable<?> variable) {
        this.name = variable.getName();
        Object declaration = variable.getGenericDeclaration();
        if (declaration instanceof Class) {
            this.declaration = TypeVariableDesc.forDeclaration(((Class)declaration).getName());
        } else if (declaration instanceof Method) {
            Method method = (Method)declaration;
            TypeDesc returnType = TypeDesc.forClass(method.getReturnType());
            TypeDesc[] paramTypes = new TypeDesc[method.getParameterTypes().length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = TypeDesc.forClass(method.getParameterTypes()[i]);
            }
            MethodDesc methodDesc = MethodDesc.forArguments(returnType, paramTypes);
            this.declaration = TypeVariableDesc.forDeclaration(method.getDeclaringClass().getName(), method.getName(), methodDesc);
        } else if (declaration instanceof Constructor) {
            Constructor ctor = (Constructor)declaration;
            TypeDesc[] paramTypes = new TypeDesc[ctor.getParameterTypes().length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = TypeDesc.forClass(ctor.getParameterTypes()[i]);
            }
            MethodDesc methodDesc = MethodDesc.forArguments(TypeDesc.VOID, paramTypes);
            this.declaration = TypeVariableDesc.forDeclaration(ctor.getDeclaringClass().getName(), "<clinit>", methodDesc);
        } else {
            throw new IllegalStateException("Unknown");
        }
    }

    public String getName() {
        return this.name;
    }

    public GenericDeclarationDesc getDeclaration() {
        return this.declaration;
    }

    public GenericTypeDesc getBounds() {
        return this.bounds;
    }

    @Override
    public String getSignature() {
        return "T" + this.name + ';';
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TypeVariableDesc)) {
            return false;
        }
        TypeVariableDesc var = (TypeVariableDesc)other;
        return this.name.equals(var.name) && this.declaration.equals(var.declaration);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() * 11 + this.declaration.hashCode() * 17;
    }

    public String toString() {
        return this.name;
    }

    @Override
    protected void resolve(TypeVariable<?> variable) {
        Type[] bounded = variable.getBounds();
        if (bounded != null && bounded.length > 0) {
            this.bounds = GenericTypeFactory.fromType(bounded[0]);
        }
    }

    protected static GenericDeclarationDesc forDeclaration(String className) {
        return ClassDeclarationDesc.forClass(className);
    }

    protected static GenericDeclarationDesc forDeclaration(String className, String methodName, MethodDesc method) {
        return MethodDeclarationDesc.forMethod(MethodInfo.forMethod(className, methodName, method));
    }

    protected static class MethodDeclarationDesc
    implements GenericDeclarationDesc {
        private final MethodInfo method;

        public static MethodDeclarationDesc forMethod(MethodInfo method) {
            return InternFactory.intern(new MethodDeclarationDesc(method));
        }

        protected MethodDeclarationDesc(MethodInfo method) {
            this.method = method;
        }

        public MethodInfo getMethod() {
            return this.method;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MethodDeclarationDesc)) {
                return false;
            }
            MethodDeclarationDesc other = (MethodDeclarationDesc)object;
            return this.getMethod().equals(other.getMethod());
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return this.method.toString();
        }
    }

    protected static class ClassDeclarationDesc
    implements GenericDeclarationDesc {
        private final String className;

        public static ClassDeclarationDesc forClass(String className) {
            return InternFactory.intern(new ClassDeclarationDesc(className));
        }

        protected ClassDeclarationDesc(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ClassDeclarationDesc)) {
                return false;
            }
            ClassDeclarationDesc other = (ClassDeclarationDesc)object;
            return this.getClassName().equals(other.getClassName());
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        public String toString() {
            return this.className;
        }
    }

    protected static interface GenericDeclarationDesc {
    }

    protected static class MethodInfo {
        private final String className;
        private final String methodName;
        private final MethodDesc method;

        public static MethodInfo forMethod(String className, String methodName, MethodDesc method) {
            return InternFactory.intern(new MethodInfo(className, methodName, method));
        }

        protected MethodInfo(String className, String methodName, MethodDesc method) {
            this.className = className;
            this.methodName = methodName;
            this.method = method;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public MethodDesc getMethod() {
            return this.method;
        }

        public int hashCode() {
            return this.className.hashCode() * 17 + this.methodName.hashCode() * 23 + this.method.hashCode() * 27;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MethodInfo)) {
                return false;
            }
            MethodInfo info = (MethodInfo)object;
            return this.className.equals(info.className) && this.methodName.equals(info.methodName) && this.method.equals(info.method);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append(this.method.getReturnType().getFullName()).append(' ').append(this.className).append(':').append(this.methodName).append('(');
            TypeDesc[] params = this.method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(params[i].getFullName());
            }
            return buffer.append(')').toString();
        }
    }
}

