/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile.generics;

import java.lang.reflect.GenericArrayType;
import org.teatrove.trove.classfile.generics.AbstractGenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeFactory;
import org.teatrove.trove.classfile.generics.InternFactory;

public class GenericArrayTypeDesc
extends AbstractGenericTypeDesc<GenericArrayType> {
    private final GenericTypeDesc componentType;

    public static GenericArrayTypeDesc forType(GenericTypeDesc componentType) {
        return InternFactory.intern(new GenericArrayTypeDesc(componentType));
    }

    public static GenericArrayTypeDesc forType(GenericArrayType type) {
        return InternFactory.intern(new GenericArrayTypeDesc(type));
    }

    protected GenericArrayTypeDesc(GenericTypeDesc componentType) {
        this.componentType = componentType;
    }

    protected GenericArrayTypeDesc(GenericArrayType type) {
        this.componentType = GenericTypeFactory.fromType(type.getGenericComponentType());
    }

    public GenericTypeDesc getComponentType() {
        return this.componentType;
    }

    @Override
    public String getSignature() {
        return "[".concat(this.componentType.getSignature());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GenericArrayTypeDesc)) {
            return false;
        }
        GenericArrayTypeDesc var = (GenericArrayTypeDesc)other;
        return this.componentType.equals(var.componentType);
    }

    @Override
    public int hashCode() {
        return 17 * this.componentType.hashCode();
    }

    public String toString() {
        return this.getComponentType().toString().concat("[]");
    }
}

