/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MethodUtils {
    private MethodUtils() {
    }

    public static Set<MethodEntry> getMethodsToImplement(Class<?> iface, Map<String, Class<?>> types, Class<?> parent) {
        HashSet<MethodEntry> methods = new HashSet<MethodEntry>();
        MethodUtils.addMethods(methods, iface, types, parent);
        return methods;
    }

    public static Set<MethodEntry> getMethodsToImplement(Class<?> iface, Map<String, Class<?>> types, Class<?> parent, Method method) {
        HashSet<MethodEntry> methods = new HashSet<MethodEntry>();
        MethodUtils.addMethods(methods, iface, types, parent, method);
        return methods;
    }

    private static int getDimensions(Type type) {
        int dimensions = 0;
        while (type instanceof GenericArrayType) {
            ++dimensions;
            type = ((GenericArrayType)type).getGenericComponentType();
        }
        return dimensions;
    }

    private static TypeVariable<?> getTypeVariable(Type type) {
        while (type instanceof GenericArrayType) {
            type = ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof TypeVariable) {
            return (TypeVariable)type;
        }
        return null;
    }

    private static boolean isBridgeRequired(Map<String, Class<?>> types, Method method) {
        TypeVariable<?> var = MethodUtils.getTypeVariable(method.getGenericReturnType());
        if (var != null && types.containsKey(var.getName())) {
            return true;
        }
        for (Type paramType : method.getGenericParameterTypes()) {
            var = MethodUtils.getTypeVariable(paramType);
            if (var == null || !types.containsKey(var.getName())) continue;
            return true;
        }
        return false;
    }

    private static Method findMethod(Class<?> clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static final Class<?> getRootType(Map<String, Class<?>> types, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type raw = ((ParameterizedType)type).getRawType();
            return MethodUtils.getRootType(types, raw);
        }
        if (type instanceof WildcardType) {
            Type[] bounds = ((WildcardType)type).getUpperBounds();
            if (bounds.length >= 1) {
                return MethodUtils.getRootType(types, bounds[0]);
            }
        } else {
            String name;
            TypeVariable<?> raw = MethodUtils.getTypeVariable(type);
            if (raw != null && types.containsKey(name = raw.getName())) {
                Class<?> actual = types.get(name);
                int dimensions = MethodUtils.getDimensions(type);
                if (dimensions >= 1) {
                    actual = Array.newInstance(actual, dimensions).getClass();
                }
                return actual;
            }
        }
        return null;
    }

    private static Class<?> getMethodType(Map<String, Class<?>> types, Type type, Class<?> clazz) {
        String name;
        TypeVariable<?> variable = MethodUtils.getTypeVariable(type);
        if (variable != null && types.containsKey(name = variable.getName())) {
            Class<?> actual = types.get(name);
            int dimensions = MethodUtils.getDimensions(type);
            if (dimensions > 0) {
                actual = Array.newInstance(actual, dimensions).getClass();
            }
            return actual;
        }
        return clazz;
    }

    private static void addMethod(Set<MethodEntry> methods, MethodEntry method) {
        if (!method.isBridged()) {
            methods.remove(method);
            methods.add(method);
        } else if (!methods.contains(method)) {
            methods.add(method);
        }
    }

    private static void addMethods(Set<MethodEntry> methods, Class<?> clazz, Map<String, Class<?>> types, Class<?> parent) {
        if (!clazz.isInterface()) {
            throw new IllegalStateException("class must be interface: " + clazz);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            MethodUtils.addMethods(methods, clazz, types, parent, method);
        }
        MethodUtils.addParentMethods(methods, clazz, types, parent, null);
    }

    private static void addMethods(Set<MethodEntry> methods, Class<?> clazz, Map<String, Class<?>> types, Class<?> parent, Method method) {
        MethodEntry impl = null;
        boolean bridged = MethodUtils.isBridgeRequired(types, method);
        if (!bridged && parent != null && MethodUtils.findMethod(parent, method) != null) {
            return;
        }
        if (bridged) {
            Class<?> returnType = MethodUtils.getMethodType(types, method.getGenericReturnType(), method.getReturnType());
            Type[] paramTypes = method.getGenericParameterTypes();
            Object[] paramClasses = method.getParameterTypes();
            for (int i = 0; i < paramClasses.length; ++i) {
                paramClasses[i] = MethodUtils.getMethodType(types, paramTypes[i], paramClasses[i]);
            }
            MethodEntry bridgeMethod = null;
            if (Arrays.equals(paramClasses, method.getParameterTypes())) {
                for (MethodEntry mentry : methods) {
                    if (!mentry.getName().equals(method.getName()) || !Arrays.equals(mentry.getParamTypes(), method.getParameterTypes())) continue;
                    bridgeMethod = mentry;
                }
            }
            impl = new MethodEntry(method.getName(), returnType, (Class<?>[])paramClasses, bridgeMethod);
            MethodUtils.addMethod(methods, impl);
        }
        MethodUtils.addMethod(methods, new MethodEntry(method.getName(), method.getReturnType(), method.getParameterTypes(), impl));
        MethodUtils.addParentMethods(methods, clazz, types, parent, method);
    }

    private static void addParentMethods(Set<MethodEntry> methods, Class<?> clazz, Map<String, Class<?>> types, Class<?> parent, Method method) {
        Class<?>[] ifaces = clazz.getInterfaces();
        Type[] generics = clazz.getGenericInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            Class<?> iface;
            Type generic = iface = ifaces[i];
            if (generics != null && i < generics.length) {
                generic = generics[i];
            }
            if (generic instanceof ParameterizedType) {
                TypeVariable<Class<?>>[] vars = iface.getTypeParameters();
                ParameterizedType ptype = (ParameterizedType)generic;
                Type[] arguments = ptype.getActualTypeArguments();
                HashMap args = new HashMap();
                for (int j = 0; j < vars.length; ++j) {
                    Type arg = arguments[j];
                    TypeVariable<Class<?>> var = vars[j];
                    Class<?> root = MethodUtils.getRootType(types, arg);
                    if (root == null) continue;
                    args.put(var.getName(), root);
                }
                if (method == null) {
                    MethodUtils.addMethods(methods, (Class)ptype.getRawType(), args, parent);
                    continue;
                }
                MethodUtils.addMethods(methods, (Class)ptype.getRawType(), args, parent, method);
                continue;
            }
            if (!(iface instanceof Class)) continue;
            if (method == null) {
                MethodUtils.addMethods(methods, iface, new HashMap(), parent);
                continue;
            }
            MethodUtils.addMethods(methods, iface, new HashMap(), parent, method);
        }
    }

    public static class MethodEntry {
        private String name;
        private Class<?> returnType;
        private Class<?>[] paramTypes;
        private MethodEntry bridgedMethod;

        public MethodEntry(String name, Class<?> returnType, Class<?>[] paramTypes, MethodEntry bridgedMethod) {
            this.name = name;
            this.returnType = returnType;
            this.paramTypes = paramTypes;
            this.bridgedMethod = bridgedMethod;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public boolean isBridged() {
            return this.bridgedMethod != null;
        }

        public MethodEntry getBridgedMethod() {
            return this.bridgedMethod;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MethodEntry)) {
                return false;
            }
            MethodEntry entry = (MethodEntry)object;
            return this.getName().equals(entry.getName()) && this.getReturnType().equals(entry.getReturnType()) && Arrays.equals(this.getParamTypes(), entry.getParamTypes());
        }

        public int hashCode() {
            return 13 + 19 * this.name.hashCode() + 21 * this.returnType.hashCode() + 23 * Arrays.hashCode(this.paramTypes);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.returnType.getName());
            buffer.append(" " + this.name + "(");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.paramTypes[i].getName());
            }
            buffer.append(")");
            if (this.bridgedMethod != null) {
                buffer.append(" [bridge] ").append(this.bridgedMethod.toString());
            }
            return buffer.toString();
        }
    }
}

