/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.FixedLocation;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.LocationRange;
import org.teatrove.trove.classfile.LocationRangeImpl;
import org.teatrove.trove.classfile.TypeDesc;

class LocalVariableTableAttr
extends Attribute {
    private List<Entry> mEntries = new ArrayList<Entry>(10);
    private List<Entry> mCleanEntries;
    private int mRangeCount;

    public LocalVariableTableAttr(ConstantPool cp) {
        super(cp, "LocalVariableTable");
    }

    public void addEntry(LocalVariable localVar) {
        String varName = localVar.getName();
        if (varName != null) {
            ConstantUTFInfo name = ConstantUTFInfo.make(this.mCp, varName);
            ConstantUTFInfo descriptor = ConstantUTFInfo.make(this.mCp, localVar.getType().toString());
            this.mEntries.add(new Entry(localVar, name, descriptor));
        }
        this.mCleanEntries = null;
    }

    @Override
    public int getLength() {
        this.clean();
        return 2 + 10 * this.mRangeCount;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mRangeCount);
        int actualLength = 0;
        for (Entry entry : this.mCleanEntries) {
            LocalVariable localVar = entry.mLocalVar;
            int name_index = entry.mName.getIndex();
            int descriptor_index = entry.mDescriptor.getIndex();
            int index = localVar.getNumber();
            this.check("local variable table entry name index", name_index);
            this.check("local variable table entry descriptor index", descriptor_index);
            this.check("local variable table entry index", index);
            for (LocationRange range : localVar.getLocationRangeSet()) {
                Location startLocation = range.getStartLocation();
                Location endLocation = range.getEndLocation();
                int start_pc = startLocation.getLocation();
                int length = endLocation.getLocation() - start_pc - 1;
                this.check("local variable table entry start PC", start_pc);
                dout.writeShort(start_pc);
                dout.writeShort(length);
                dout.writeShort(name_index);
                dout.writeShort(descriptor_index);
                dout.writeShort(index);
                ++actualLength;
            }
        }
        if (actualLength != this.mRangeCount) {
            throw new IllegalStateException("Error while writing the local variable table attribute.  Length [" + this.mRangeCount + "] does not match actual length [" + actualLength + "]");
        }
    }

    private void check(String type, int addr) throws RuntimeException {
        if (addr < 0 || addr > 65535) {
            throw new RuntimeException("Value for " + type + " out of " + "valid range: " + addr);
        }
    }

    private void clean() {
        if (this.mCleanEntries != null) {
            return;
        }
        int size = this.mEntries.size();
        this.mCleanEntries = new ArrayList<Entry>(size);
        this.mRangeCount = 0;
        block0: for (int i = 0; i < size; ++i) {
            Entry entry = this.mEntries.get(i);
            LocalVariable localVar = entry.mLocalVar;
            SortedSet<LocationRange> ranges = localVar.getLocationRangeSet();
            if (ranges == null || ranges.size() == 0) continue;
            for (LocationRange range : ranges) {
                Location startLocation = range.getStartLocation();
                Location endLocation = range.getEndLocation();
                if (startLocation == null || endLocation == null) continue block0;
                int start_pc = startLocation.getLocation();
                int length = endLocation.getLocation() - start_pc - 1;
                if (length >= 0) continue;
                continue block0;
            }
            this.mCleanEntries.add(entry);
            this.mRangeCount += entry.getRangeCount();
        }
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        LocalVariableTableAttr locals = new LocalVariableTableAttr(cp);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int start_pc = din.readUnsignedShort();
            int end_pc = start_pc + din.readUnsignedShort() + 1;
            int name_index = din.readUnsignedShort();
            int descriptor_index = din.readUnsignedShort();
            final int index = din.readUnsignedShort();
            final ConstantUTFInfo varName = (ConstantUTFInfo)cp.getConstant(name_index);
            final ConstantUTFInfo varDesc = (ConstantUTFInfo)cp.getConstant(descriptor_index);
            FixedLocation startLocation = new FixedLocation(start_pc);
            FixedLocation endLocation = new FixedLocation(end_pc);
            TreeSet<LocationRangeImpl> ranges = new TreeSet<LocationRangeImpl>();
            ranges.add(new LocationRangeImpl(startLocation, endLocation));
            final SortedSet fRanges = Collections.unmodifiableSortedSet(ranges);
            LocalVariable localVar = new LocalVariable(){
                private String mName;
                private TypeDesc mType;
                {
                    this.mName = varName.getValue();
                    this.mType = TypeDesc.forDescriptor(varDesc.getValue());
                }

                @Override
                public String getName() {
                    return this.mName;
                }

                @Override
                public void setName(String name) {
                    this.mName = name;
                }

                @Override
                public TypeDesc getType() {
                    return this.mType;
                }

                @Override
                public boolean isDoubleWord() {
                    return this.mType.isDoubleWord();
                }

                @Override
                public int getNumber() {
                    return index;
                }

                public SortedSet getLocationRangeSet() {
                    return fRanges;
                }
            };
            Entry entry = new Entry(localVar, varName, varDesc);
            locals.mEntries.add(entry);
        }
        return locals;
    }

    private static class Entry {
        public LocalVariable mLocalVar;
        public ConstantUTFInfo mName;
        public ConstantUTFInfo mDescriptor;

        public Entry(LocalVariable localVar, ConstantUTFInfo name, ConstantUTFInfo descriptor) {
            this.mLocalVar = localVar;
            this.mName = name;
            this.mDescriptor = descriptor;
        }

        public int getRangeCount() {
            return this.mLocalVar.getLocationRangeSet().size();
        }
    }
}

