/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;

class ConstantValueAttr
extends Attribute {
    private ConstantInfo mConstant;

    public ConstantValueAttr(ConstantPool cp, ConstantInfo constant) {
        super(cp, "ConstantValue");
        this.mConstant = constant;
    }

    public ConstantInfo getConstant() {
        return this.mConstant;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mConstant.getIndex());
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        int index = din.readUnsignedShort();
        if ((length -= 2) > 0) {
            din.skipBytes(length);
        }
        return new ConstantValueAttr(cp, cp.getConstant(index));
    }
}

