/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;

public class ConstantIntegerInfo
extends ConstantInfo {
    private Integer mValue;

    static ConstantIntegerInfo make(ConstantPool cp, int value) {
        ConstantIntegerInfo ci = new ConstantIntegerInfo(value);
        return (ConstantIntegerInfo)cp.addConstant(ci);
    }

    ConstantIntegerInfo(int value) {
        super(3);
        this.mValue = new Integer(value);
    }

    ConstantIntegerInfo(Integer value) {
        super(3);
        this.mValue = value;
    }

    public Integer getValue() {
        return this.mValue;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantIntegerInfo) {
            ConstantIntegerInfo other = (ConstantIntegerInfo)obj;
            return this.mValue.equals(other.mValue);
        }
        return false;
    }

    @Override
    boolean hasPriority() {
        return true;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeInt(this.mValue);
    }

    public String toString() {
        return "CONSTANT_Integer_info: " + this.getValue();
    }
}

